/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class PositionedFluidTank {
    public FluidTank[] tanks;
    public FluidTank tank;
    public Rectangle position;
    public String overlayTexture;
    public Point overlayTexturePos;
    public boolean flowingTexture = false;
    public boolean showAmount = true;
    public boolean perTick = false;

    public PositionedFluidTank(FluidTank[] tanks, Rectangle position, String overlayTexture, Point overlayTexturePos) {
        this.position = position;
        this.tanks = tanks;
        this.tank = tanks[0];
        this.overlayTexture = overlayTexture;
        this.overlayTexturePos = overlayTexturePos;
    }

    public PositionedFluidTank(Collection<FluidStack> fluids, int capacity, Rectangle position, String overlayTexture, Point overlayTexturePos) {
        this(PositionedFluidTank.createFluidTanks(capacity, fluids), position, overlayTexture, overlayTexturePos);
    }

    public PositionedFluidTank(FluidStack fluid, int capacity, Rectangle position, String overlayTexture, Point overlayTexturePos) {
        this(PositionedFluidTank.createFluidTanks(capacity, Collections.singletonList(fluid)), position, overlayTexture, overlayTexturePos);
    }

    public PositionedFluidTank(FluidStack fluid, int capacity, Rectangle position) {
        this(fluid, capacity, position, null, null);
    }

    private static FluidTank[] createFluidTanks(int capacity, Collection<FluidStack> fluidStacks) {
        FluidTank[] tanks = new FluidTank[fluidStacks.size()];
        int i = 0;
        for (FluidStack fluidStack : fluidStacks) {
            tanks[i++] = new FluidTank(fluidStacks != null ? fluidStack.copy() : null, capacity);
        }
        return tanks;
    }

    public List<String> handleTooltip(List<String> currenttip) {
        if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluid().amount <= 0) {
            return currenttip;
        }
        currenttip.add(this.tank.getFluid().getLocalizedName());
        if (this.showAmount) {
            currenttip.add(EnumChatFormatting.GRAY.toString() + this.tank.getFluid().amount + (this.perTick ? " mB/t" : " mB"));
        }
        return currenttip;
    }

    public boolean transfer(boolean usage) {
        if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
            if (usage) {
                return GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank.getFluid()});
            }
            return GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank.getFluid()});
        }
        return false;
    }

    public void draw() {
        IIcon fluidIcon;
        if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluid().amount <= 0) {
            return;
        }
        if (this.flowingTexture && this.tank.getFluid().getFluid().getFlowingIcon() != null) {
            fluidIcon = this.tank.getFluid().getFluid().getFlowingIcon();
        } else if (this.tank.getFluid().getFluid().getStillIcon() != null) {
            fluidIcon = this.tank.getFluid().getFluid().getStillIcon();
        } else {
            return;
        }
        GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
        int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        int amount = Math.max(Math.min(this.position.height, this.tank.getFluid().amount * this.position.height / this.tank.getCapacity()), 1);
        int posY = this.position.y + this.position.height - amount;
        for (int i = 0; i < this.position.width; i += 16) {
            for (int j = 0; j < amount; j += 16) {
                int drawWidth = Math.min(this.position.width - i, 16);
                int drawHeight = Math.min(amount - j, 16);
                int drawX = this.position.x + i;
                int drawY = posY + j;
                double minU = fluidIcon.func_94209_e();
                double maxU = fluidIcon.func_94212_f();
                double minV = fluidIcon.func_94206_g();
                double maxV = fluidIcon.func_94210_h();
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                tessellator.func_78381_a();
            }
        }
        if (this.overlayTexture != null && this.overlayTexturePos != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)this.overlayTexture);
            GuiDraw.drawTexturedModalRect((int)this.position.x, (int)this.position.y, (int)this.overlayTexturePos.x, (int)this.overlayTexturePos.y, (int)this.position.width, (int)this.position.height);
        }
    }

    public void setPermutationToRender(int index) {
        this.tank = this.tanks[index];
    }

    public int getPermutationCount() {
        return this.tanks.length;
    }
}

