/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network;

import binnie.core.BinnieCore;
import binnie.core.block.TileEntityMetadata;
import binnie.core.craftgui.minecraft.ContainerCraftGUI;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.network.packet.MessageMetadata;
import binnie.core.network.packet.MessageTileNBT;
import binnie.core.network.packet.MessageUpdate;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;

public enum BinnieCorePacketID implements IPacketID
{
    NetworkEntityUpdate,
    TileMetadata,
    CraftGUIAction,
    TileDescriptionSync;


    @Override
    public void onMessage(MessageBinnie message, MessageContext context) {
        switch (this) {
            case NetworkEntityUpdate: {
                BinnieCorePacketID.processNetworkEntityUpdate(message);
                break;
            }
            case TileMetadata: {
                BinnieCorePacketID.processTileMetadata(message);
                break;
            }
            case CraftGUIAction: {
                BinnieCorePacketID.processCraftGUIAction(message, context);
                break;
            }
            case TileDescriptionSync: {
                BinnieCorePacketID.processTileDescriptionSync(message, context);
            }
        }
    }

    private static void processNetworkEntityUpdate(MessageBinnie message) {
        MessageUpdate packet = new MessageUpdate(message);
        TileEntity tile = packet.getTileEntity(BinnieCore.proxy.getWorld());
        if (tile instanceof INetworkedEntity) {
            INetworkedEntity iNetworkedEntity = (INetworkedEntity)tile;
            iNetworkedEntity.readFromPacket(packet.payload);
        }
    }

    private static void processTileMetadata(MessageBinnie message) {
        MessageMetadata packet = new MessageMetadata(message);
        TileEntity tile = packet.getTileEntity(BinnieCore.proxy.getWorld());
        if (tile instanceof TileEntityMetadata) {
            TileEntityMetadata tileEntityMetadata = (TileEntityMetadata)tile;
            tileEntityMetadata.setTileMetadata(packet.meta, true);
        }
    }

    private static void processCraftGUIAction(MessageBinnie message, MessageContext context) {
        MessageCraftGUI packet = new MessageCraftGUI(message);
        NBTTagCompound tagCompound = packet.getTagCompound();
        if (tagCompound == null) {
            return;
        }
        if (context.side == Side.CLIENT) {
            EntityPlayer player = BinnieCore.proxy.getPlayer();
            Container container = player.field_71070_bA;
            if (container instanceof ContainerCraftGUI) {
                ContainerCraftGUI gui = (ContainerCraftGUI)container;
                gui.receiveNBT(Side.CLIENT, player, tagCompound);
            }
        } else {
            INetHandler gui = context.netHandler;
            if (gui instanceof NetHandlerPlayServer) {
                NetHandlerPlayServer server = (NetHandlerPlayServer)gui;
                EntityPlayerMP player = server.field_147369_b;
                Container container = player.field_71070_bA;
                if (container instanceof ContainerCraftGUI) {
                    ContainerCraftGUI gui2 = (ContainerCraftGUI)container;
                    gui2.receiveNBT(Side.SERVER, (EntityPlayer)player, tagCompound);
                }
            }
        }
    }

    private static void processTileDescriptionSync(MessageBinnie message, MessageContext context) {
        if (!context.side.isClient()) {
            return;
        }
        MessageTileNBT packet = new MessageTileNBT(message);
        NBTTagCompound tagCompound = packet.getTagCompound();
        if (tagCompound == null) {
            return;
        }
        TileEntity tile = packet.getTarget(BinnieCore.proxy.getWorld());
        if (tile == null) {
            return;
        }
        IMachine machine = Machine.getMachine(tile);
        if (machine instanceof INetwork.TilePacketSync) {
            INetwork.TilePacketSync tps = (INetwork.TilePacketSync)((Object)machine);
            tps.syncFromNBT(tagCompound);
        }
    }
}

