/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.block.PlankType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockETPlanks
extends BlockWood
implements IBlockMetadata {
    public BlockETPlanks() {
        this.func_149663_c("planks");
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149766_f);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventType) {
        super.func_149696_a(world, x, y, z, eventId, eventType);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null && tileentity.func_145842_c(eventId, eventType);
    }

    @Override
    public int getPlacedMeta(ItemStack itemStack, World world, int x, int y, int z, ForgeDirection direction) {
        return TileEntityMetadata.getItemDamage(itemStack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack itemStack) {
        int meta = TileEntityMetadata.getItemDamage(itemStack);
        return I18N.localise("extratrees.block.plank.name", PlankType.ExtraTreePlanks.values()[meta].getName());
    }

    @Override
    public void addBlockTooltip(ItemStack itemStack, List<String> tooltip) {
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack itemStack) {
        this.func_149642_a(world, x, y, z, itemStack);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < PlankType.ExtraTreePlanks.values().length; ++i) {
            list.add(TileEntityMetadata.getItemStack((Block)this, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.func_149691_a(side, tile.getTileMetadata());
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public IIcon func_149691_a(int side, int meta) {
        return PlankType.ExtraTreePlanks.values()[meta].getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (PlankType.ExtraTreePlanks plank : PlankType.ExtraTreePlanks.values()) {
            plank.loadIcon(register);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int side) {
        super.func_149749_a(world, x, y, z, block, side);
        world.func_147475_p(x, y, z);
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

