/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.item;

import binnie.Binnie;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.ILiquidType;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public enum ExtraTreeLiquid implements ILiquidType
{
    Sap("sap", 12481858),
    Resin("resin", 13199360),
    Latex("latex", 14212041),
    Turpentine("turpentine", 7951162);

    public final String name;
    private final String ident;
    private IIcon icon;
    private final int color;

    private ExtraTreeLiquid(String name, int color) {
        this.name = name;
        this.ident = name;
        this.color = color;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IIconRegister register) {
        this.icon = ExtraTrees.proxy.getIcon(register, "liquids/" + this.getIdentifier());
    }

    @Override
    public String getName() {
        return I18N.localise("extratrees.fluid." + this.name);
    }

    @Override
    public String getIdentifier() {
        return this.ident;
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public FluidStack get(int amount) {
        return Binnie.Liquid.getLiquidStack(this.ident, amount);
    }

    @Override
    public int getTransparency() {
        return 255;
    }

    @Override
    public boolean canPlaceIn(FluidContainer container) {
        return true;
    }

    @Override
    public boolean showInCreative(FluidContainer container) {
        return container == FluidContainer.Bucket || container == FluidContainer.Can || container == FluidContainer.Capsule;
    }

    @Override
    public int getContainerColor() {
        return this.color;
    }
}

