/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.gui.AnalystPageProduce;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.ISpeciesRoot;
import forestry.arboriculture.FruitProviderPod;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class AnalystPageFruit
extends AnalystPageProduce {
    public AnalystPageFruit(IWidget parent, IArea area, ITree ind) {
        super(parent, area);
        ControlItemDisplay d;
        this.setColor(0xCC3300);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, EnumChatFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        String alleleName = Binnie.Genetics.treeBreedingSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.YIELD, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD));
        new ControlTextCentered((IWidget)this, y += 12, EnumChatFormatting.ITALIC + I18N.localise("genetics.gui.analyst.fruit.yield", alleleName)).setColor(this.getColor());
        y += 20;
        UniqueItemStackSet products = new UniqueItemStackSet();
        UniqueItemStackSet specialties = new UniqueItemStackSet();
        Collections.addAll(products, ind.getProduceList());
        Collections.addAll(specialties, ind.getSpecialtyList());
        try {
            if (ind.getGenome().getFruitProvider() instanceof FruitProviderPod) {
                FruitProviderPod pod = (FruitProviderPod)ind.getGenome().getFruitProvider();
                Field f = FruitProviderPod.class.getDeclaredField("drop");
                f.setAccessible(true);
                Collections.addAll(products, (ItemStack[])f.get(pod));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (products.size() > 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.natural")).setColor(this.getColor());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : products) {
                d = new ControlItemDisplay(this, (this.w() - (float)w) / 2.0f + (float)(18 * i), y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        if (specialties.size() > 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.speciality")).setColor(this.getColor());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : specialties) {
                d = new ControlItemDisplay(this, (this.w() - (float)w) / 2.0f + (float)(18 * i), y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        UniqueItemStackSet allProducts = new UniqueItemStackSet();
        allProducts.addAll(products);
        allProducts.addAll(specialties);
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        refinedProducts.addAll(this.getAllProductsAndFluids(allProducts));
        if (refinedProducts.size() > 0) {
            y = this.getRefined(I18N.localise("genetics.gui.analyst.fruit.refined"), y, refinedProducts);
            y += 8;
        }
        if (products.size() == 0 && specialties.size() == 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.none")).setColor(this.getColor());
            y += 28;
        }
        new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.fruit.possible")).setColor(this.getColor());
        y += 12;
        Collection fruitAlleles = Binnie.Genetics.getChromosomeMap((ISpeciesRoot)Binnie.Genetics.getTreeRoot()).get(EnumTreeChromosome.FRUITS);
        for (IFruitFamily fam : ind.getGenome().getPrimary().getSuitableFruit()) {
            UniqueItemStackSet stacks = new UniqueItemStackSet();
            for (IAllele a : fruitAlleles) {
                if (((IAlleleFruit)a).getProvider().getFamily() != fam) continue;
                Collections.addAll(stacks, ((IAlleleFruit)a).getProvider().getProducts());
                Collections.addAll(stacks, ((IAlleleFruit)a).getProvider().getSpecialty());
                try {
                    if (a.getUID().contains("fruitCocoa")) {
                        stacks.add(new ItemStack(Items.field_151100_aR, 1, 3));
                        continue;
                    }
                    if (!(((IAlleleFruit)a).getProvider() instanceof FruitProviderPod)) continue;
                    FruitProviderPod pod2 = (FruitProviderPod)((IAlleleFruit)a).getProvider();
                    Field field = FruitProviderPod.class.getDeclaredField("drop");
                    field.setAccessible(true);
                    Collections.addAll(stacks, (ItemStack[])field.get(pod2));
                }
                catch (Exception exception) {}
            }
            y = this.getRefined(EnumChatFormatting.ITALIC + fam.getName(), y, stacks) + 2;
        }
        this.setSize(new IPoint(this.w(), y + 8));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.fruit");
    }
}

