/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.inoculator;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.inoculator.Inoculator;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InoculatorComponentLogic
extends ComponentProcessSetCost
implements IProcess {
    private float bacteriaDrain = 0.0f;

    public InoculatorComponentLogic(Machine machine) {
        super(machine, 600000, 12000);
    }

    @Override
    public int getProcessLength() {
        return super.getProcessLength() * this.getNumberOfGenes();
    }

    @Override
    public int getProcessEnergy() {
        return super.getProcessEnergy() * this.getNumberOfGenes();
    }

    private int getNumberOfGenes() {
        ItemStack serum = this.getUtil().getStack(0);
        if (serum == null) {
            return 1;
        }
        return Engineering.getGenes(serum).length;
    }

    @Override
    public String getTooltip() {
        int n = this.getNumberOfGenes();
        if (n > 1) {
            return I18N.localise("genetics.machine.inoculator.inoculatingWithGenes", n);
        }
        return I18N.localise("genetics.machine.inoculator.inoculatingWithGene");
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(9)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.inoculator.error.noIndividual"), 9);
        }
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.inoculator.error.noSerum"), 0);
        }
        if (this.getUtil().isTankEmpty(0)) {
            return new ErrorState.InsufficientLiquid(I18N.localise("genetics.machine.inoculator.error.noLiquid"), 0);
        }
        ErrorState state = this.isValidSerum();
        if (state != null) {
            return state;
        }
        ItemStack stack = this.getUtil().getStack(0);
        if (stack != null && Engineering.getCharges(stack) == 0) {
            return new ErrorState(I18N.localise("genetics.machine.inoculator.error.emptySerum.title"), I18N.localise("genetics.machine.inoculator.error.emptySerum"));
        }
        return super.canWork();
    }

    public ErrorState isValidSerum() {
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        IGene[] genes = Engineering.getGenes(serum);
        if (genes.length == 0) {
            return new ErrorState(I18N.localise("genetics.machine.inoculator.error.invalidSerum.title"), I18N.localise("genetics.machine.inoculator.error.invalidSerum.0"));
        }
        if (!genes[0].getSpeciesRoot().isMember(target)) {
            return new ErrorState(I18N.localise("genetics.machine.inoculator.error.invalidSerum.title"), I18N.localise("genetics.machine.inoculator.error.invalidSerum.1"));
        }
        IIndividual individual = genes[0].getSpeciesRoot().getMember(target);
        boolean hasAll = true;
        for (IGene gene : genes) {
            if (!hasAll) continue;
            IGenome genome = individual.getGenome();
            IChromosomeType chromosome = gene.getChromosome();
            String geneAlleleUID = gene.getAllele().getUID();
            IAllele a = genome.getActiveAllele(chromosome);
            IAllele b = genome.getInactiveAllele(chromosome);
            hasAll = a.getUID().equals(geneAlleleUID) && b.getUID().equals(geneAlleleUID);
        }
        if (!hasAll) {
            return null;
        }
        return new ErrorState(I18N.localise("genetics.machine.inoculator.error.defunctSerum.title"), I18N.localise("genetics.machine.inoculator.error.defunctSerum"));
    }

    @Override
    public ErrorState canProgress() {
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        IGene[] genes;
        super.onFinishTask();
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(target);
        if (!ind.isAnalyzed()) {
            ind.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ind.writeToNBT(nbttagcompound);
            target.func_77982_d(nbttagcompound);
        }
        for (IGene gene : genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum)) {
            Inoculator.setGene(gene, target, 0);
            Inoculator.setGene(gene, target, 1);
        }
        this.getUtil().damageItem(0, 1);
    }

    @Override
    protected void onTickTask() {
        this.bacteriaDrain += 15.0f * this.getProgressPerTick() / 100.0f;
        if (this.bacteriaDrain >= 1.0f) {
            this.getUtil().drainTank(0, 1);
            this.bacteriaDrain -= 1.0f;
        }
    }
}

