/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.renderer;

import blockrenderer6343.client.utils.ProjectionUtils;
import blockrenderer6343.client.world.TrackedDummyWorld;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public abstract class WorldSceneRenderer {
    public static int backgroundColor = 0xC6C6C6;
    public final TrackedDummyWorld world;
    public final LongSet renderedBlocks = new LongOpenHashSet();
    public final LongArrayList renderTranslucentBlocks = new LongArrayList();
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> onRender;
    private Consumer<MovingObjectPosition> onLookingAt;
    private Consumer<WorldSceneRenderer> onPostBlockRendered;
    private MovingObjectPosition lastTraceResult;
    private final Vector3f eyePos = new Vector3f(0.0f, 0.0f, -10.0f);
    private final Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
    protected Vector4i rect = new Vector4i();
    private boolean renderAllFaces = false;
    private final RenderBlocks bufferBuilder = new RenderBlocks();

    public WorldSceneRenderer(TrackedDummyWorld world) {
        this.world = world;
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setPostBlockRender(Consumer<WorldSceneRenderer> callback) {
        this.onPostBlockRendered = callback;
        return this;
    }

    public WorldSceneRenderer setOnWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.onRender = callback;
        return this;
    }

    public void setRenderAllBlocks() {
        this.resetRenderedBlocks();
        this.setRenderAllFaces(false);
        this.renderedBlocks.addAll((LongCollection)this.world.blockMap.keySet());
        this.world.setVisibleYLevel(-1);
    }

    public void setRenderYLayer(int layer) {
        this.resetRenderedBlocks();
        this.setRenderAllFaces(true);
        int minY = (int)this.world.getMinPos().y();
        this.world.setVisibleYLevel(minY + layer);
        LongIterator longIterator = this.world.blockMap.keySet().iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (CoordinatePacker.unpackY((long)pos) - minY != layer) continue;
            this.renderedBlocks.add(pos);
        }
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<MovingObjectPosition> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public void setRenderAllFaces(boolean renderAllFaces) {
        this.renderAllFaces = renderAllFaces;
    }

    public MovingObjectPosition getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void resetRenderedBlocks() {
        this.renderedBlocks.clear();
        this.renderTranslucentBlocks.clear();
    }

    public void render(int x, int y, int width, int height, int mouseX, int mouseY) {
        Vector3f lookVec;
        MovingObjectPosition result;
        this.rect.set(x, y, width, height);
        this.setupCamera();
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && this.isInsideRect(mouseX, mouseY) && (result = this.rayTrace(lookVec = ProjectionUtils.unProject(this.rect, this.eyePos, this.lookAt, mouseX, mouseY))) != null) {
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        WorldSceneRenderer.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos.set((Vector3fc)eyePos);
        this.lookAt.set((Vector3fc)lookAt);
        this.worldUp.set((Vector3fc)worldUp);
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        this.lookAt.set((Vector3fc)lookAt);
        this.eyePos.set((float)Math.cos(rotationPitch), 0.0f, (float)Math.sin(rotationPitch)).add(0.0f, (float)(Math.tan(rotationYaw) * (double)this.eyePos.length()), 0.0f).normalize().mul((float)radius).add((Vector3fc)lookAt);
    }

    public void setupCamera() {
        int x = this.rect.x;
        int y = this.rect.y;
        int width = this.rect.z;
        int height = this.rect.w;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushClientAttrib((int)-1);
        mc.field_71460_t.func_78483_a(0.0);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
        this.clearView(x, y, width, height);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluLookAt((float)this.eyePos.x, (float)this.eyePos.y, (float)this.eyePos.z, (float)this.lookAt.x, (float)this.lookAt.y, (float)this.lookAt.z, (float)this.worldUp.x, (float)this.worldUp.y, (float)this.worldUp.z);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        GL11.glClearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    protected void clearView(int x, int y, int width, int height) {
        WorldSceneRenderer.setGlClearColorFromInt(backgroundColor, backgroundColor >> 24);
        GL11.glClear((int)16640);
    }

    public static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopClientAttrib();
        GL11.glPopAttrib();
    }

    private double getDistanceSq(long coord) {
        int x = CoordinatePacker.unpackX((long)coord);
        int y = CoordinatePacker.unpackY((long)coord);
        int z = CoordinatePacker.unpackZ((long)coord);
        double xd = this.eyePos.x - (float)x;
        double yd = this.eyePos.y - (float)y;
        double zd = this.eyePos.z - (float)z;
        return xd * xd + yd * yd + zd * zd;
    }

    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)32826);
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_78483_a(0.0);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        if (!this.renderTranslucentBlocks.isEmpty()) {
            this.renderTranslucentBlocks.sort((a, b) -> -Double.compare(this.getDistanceSq(a), this.getDistanceSq(b)));
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        this.renderBlocks(tessellator, (LongCollection)this.renderedBlocks, false);
        this.renderBlocks(tessellator, (LongCollection)this.renderTranslucentBlocks, true);
        if (this.onPostBlockRendered != null) {
            this.onPostBlockRendered.accept(this);
        }
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2896);
        TileEntityRendererDispatcher tesr = TileEntityRendererDispatcher.field_147556_a;
        int pass = 0;
        while (pass < 2) {
            ForgeHooksClient.setRenderPass((int)pass);
            int finalPass = pass++;
            this.renderedBlocks.forEach(pos -> {
                int x = CoordinatePacker.unpackX((long)pos);
                int y = CoordinatePacker.unpackY((long)pos);
                int z = CoordinatePacker.unpackZ((long)pos);
                WorldSceneRenderer.setDefaultPassRenderState(finalPass);
                TileEntity tile = this.world.func_147438_o(x, y, z);
                if (tile != null && tesr.func_147545_a(tile) && tile.shouldRenderInPass(finalPass)) {
                    tesr.func_147549_a(tile, (double)x, (double)y, (double)z, 0.0f);
                }
            });
        }
        ForgeHooksClient.setRenderPass((int)-1);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderBlocks(Tessellator tessellator, LongCollection blocksToRender, boolean transparent) {
        if (blocksToRender.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int savedAo = mc.field_71474_y.field_74348_k;
        mc.field_71474_y.field_74348_k = 0;
        tessellator.func_78382_b();
        try {
            if (transparent) {
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.3f);
                tessellator.func_78383_c();
            }
            tessellator.func_78380_c(0xF000F0);
            for (int i = 0; i < 2; ++i) {
                LongIterator longIterator = blocksToRender.iterator();
                while (longIterator.hasNext()) {
                    int z;
                    int y;
                    long pos = (Long)longIterator.next();
                    int x = CoordinatePacker.unpackX((long)pos);
                    Block block = this.world.func_147439_a(x, y = CoordinatePacker.unpackY((long)pos), z = CoordinatePacker.unpackZ((long)pos));
                    if (block.equals(Blocks.field_150350_a) || !block.canRenderInPass(i)) continue;
                    this.bufferBuilder.field_147845_a = this.world;
                    this.bufferBuilder.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                    this.bufferBuilder.field_147837_f = this.renderAllFaces;
                    this.bufferBuilder.func_147805_b(block, x, y, z);
                }
            }
            if (this.onRender != null) {
                this.onRender.accept(this);
            }
        }
        finally {
            mc.field_71474_y.field_74348_k = savedAo;
            tessellator.func_78381_a();
            tessellator.func_78373_b(0.0, 0.0, 0.0);
        }
    }

    public static void setDefaultPassRenderState(int pass) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
        }
    }

    public boolean isInsideRect(int x, int y) {
        return x > this.rect.x() && x < this.rect.x() + this.rect.z() && y > this.rect.y() && y < this.rect.y() + this.rect.w();
    }

    public MovingObjectPosition rayTrace(Vector3f lookVec) {
        Vec3 startPos = Vec3.func_72443_a((double)this.eyePos.x, (double)this.eyePos.y, (double)this.eyePos.z);
        lookVec.mul(100.0f);
        Vec3 endPos = Vec3.func_72443_a((double)((double)lookVec.x + startPos.field_72450_a), (double)((double)lookVec.y + startPos.field_72448_b), (double)((double)lookVec.z + startPos.field_72449_c));
        return this.world.rayTraceBlocksWithTargetMap(startPos, endPos, this.world.blockMap.keySet());
    }
}

