/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.dropoff;

import com.cleanroommc.bogosorter.BogoSorter;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class LocalizationHelper {
    private static final Map<String, Map<String, String>> translationCache = new HashMap<String, Map<String, String>>();

    public static String getDisplayNameEnglish(ItemStack itemStack) {
        String unlocalizedName = itemStack.func_77977_a() + ".name";
        for (ModContainer mod : Loader.instance().getModList()) {
            String modId = mod.getModId();
            Map<String, String> modTranslations = LocalizationHelper.fetchModTranslation(modId);
            if (!modTranslations.containsKey(unlocalizedName)) continue;
            return modTranslations.get(unlocalizedName);
        }
        return StatCollector.func_150826_b((String)unlocalizedName);
    }

    private static Map<String, String> fetchModTranslation(String modId) {
        if (translationCache.containsKey(modId)) {
            return translationCache.get(modId);
        }
        Map<String, String> modTranslations = LocalizationHelper.loadModLanguageFile(modId);
        translationCache.put(modId, modTranslations);
        return modTranslations;
    }

    private static Map<String, String> loadModLanguageFile(String modId) {
        HashMap<String, String> translations = new HashMap<String, String>();
        String resourcePath = "/assets/" + modId.toLowerCase() + "/lang/en_US.lang";
        InputStream stream = LocalizationHelper.class.getResourceAsStream(resourcePath);
        if (stream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.startsWith("#") || !line.contains("=") || (parts = line.split("=", 2)).length != 2) continue;
                    translations.put(parts[0].trim(), parts[1].trim());
                }
            }
            catch (IOException | NullPointerException e) {
                BogoSorter.LOGGER.error("Failed to load en_US.lang for mod: {}", new Object[]{modId});
                e.printStackTrace();
            }
        }
        return translations;
    }
}

