/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.tablet.PacketTabletMessage;
import buildcraft.core.tablet.TabletBase;
import buildcraft.core.tablet.TabletServer;
import buildcraft.core.tablet.manager.TabletManagerClient;
import buildcraft.core.tablet.manager.TabletManagerServer;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;

public class PacketHandlerCore
extends PacketHandler {
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        super.channelRead0(ctx, packet);
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
        switch (packet.getID()) {
            case 40: {
                if (ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get() == Side.SERVER) {
                    this.handleTabletClient((PacketTabletMessage)packet);
                    break;
                }
                this.handleTabletServer(player, (PacketTabletMessage)packet);
            }
        }
    }

    private void handleTabletClient(PacketTabletMessage packet) {
        TabletBase tablet = TabletManagerClient.INSTANCE.get().getTablet();
        tablet.receiveMessage(packet.getTag());
    }

    private void handleTabletServer(EntityPlayer player, PacketTabletMessage packet) {
        TabletServer tablet = TabletManagerServer.INSTANCE.get(player);
        ((TabletBase)tablet).receiveMessage(packet.getTag());
    }
}

