/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportPower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;

@SideOnly(value=Side.CLIENT)
public final class PipeToolTipManager {
    private static final Map<Class<? extends Pipe<?>>, String> toolTips = new HashMap();

    private PipeToolTipManager() {
    }

    private static void addTipToList(String tipTag, List<String> tips) {
        String localized;
        if (StringUtils.canLocalize(tipTag) && (localized = StringUtils.localize(tipTag)) != null) {
            List lines = StringUtils.newLineSplitter.splitToList((CharSequence)localized);
            tips.addAll(lines);
        }
    }

    public static void addToolTip(Class<? extends Pipe<?>> pipe, String toolTip) {
        toolTips.put(pipe, toolTip);
    }

    public static List<String> getToolTip(Class<? extends Pipe<?>> pipe, boolean advanced) {
        ArrayList<String> tips = new ArrayList<String>();
        PipeToolTipManager.addTipToList("tip." + pipe.getSimpleName(), tips);
        String tip = toolTips.get(pipe);
        if (tip != null) {
            tips.add(tip);
        }
        if (GuiScreen.func_146272_n()) {
            PipeToolTipManager.addTipToList("tip.shift." + pipe.getSimpleName(), tips);
        }
        return tips;
    }

    static {
        if (!BuildCraftCore.hidePowerNumbers && !BuildCraftTransport.usePipeLoss) {
            for (Map.Entry<Class<Pipe<?>>, Integer> pipe : PipeTransportPower.powerCapacities.entrySet()) {
                PipeToolTipManager.addToolTip(pipe.getKey(), String.format("%d RF/t", pipe.getValue()));
            }
        }
        if (!BuildCraftCore.hideFluidNumbers) {
            for (Map.Entry<Class<Pipe<?>>, Integer> pipe : PipeTransportFluids.fluidCapacities.entrySet()) {
                PipeToolTipManager.addToolTip(pipe.getKey(), String.format("%d mB/t", pipe.getValue()));
            }
        }
    }
}

