/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.network;

import buildcraft.compat.forestry.pipes.PipeHelper;
import buildcraft.compat.forestry.pipes.PipeItemsPropolis;
import buildcraft.compat.forestry.pipes.PipeLogicPropolis;
import buildcraft.compat.forestry.pipes.gui.ContainerPropolisPipe;
import buildcraft.compat.forestry.pipes.network.PacketGenomeFilterChange;
import buildcraft.compat.forestry.pipes.network.PacketRequestFilterSet;
import buildcraft.compat.forestry.pipes.network.PacketTypeFilterChange;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketHandler;
import buildcraft.core.lib.network.PacketNBT;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.INetHandler;

@ChannelHandler.Sharable
public class PacketHandlerCompat
extends PacketHandler {
    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        super.channelRead0(ctx, packet);
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
        switch (packet.getID()) {
            case 120: {
                PacketHandlerCompat.onFilterSet((PacketNBT)packet);
                break;
            }
            case 121: {
                PacketHandlerCompat.onRequestFilterSet(player, (PacketRequestFilterSet)packet);
                break;
            }
            case 123: {
                PacketHandlerCompat.onTypeFilterChange(player, (PacketTypeFilterChange)packet);
                break;
            }
            case 122: {
                PacketHandlerCompat.onGenomeFilterChange(player, (PacketGenomeFilterChange)packet);
            }
        }
    }

    private static void onFilterSet(PacketNBT packet) {
        Container container = FMLClientHandler.instance().getClient().field_71439_g.field_71070_bA;
        if (container instanceof ContainerPropolisPipe) {
            PipeLogicPropolis pipeLogic = ((ContainerPropolisPipe)container).pipeLogic;
            pipeLogic.handleFilterSet(packet);
        }
    }

    private static void onTypeFilterChange(EntityPlayer player, PacketTypeFilterChange packet) {
        PipeItemsPropolis pipe = PipeHelper.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ, PipeItemsPropolis.class);
        if (pipe == null) {
            return;
        }
        pipe.pipeLogic.handleTypeFilterChange(packet);
    }

    private static void onGenomeFilterChange(EntityPlayer player, PacketGenomeFilterChange packet) {
        PipeItemsPropolis pipe = PipeHelper.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ, PipeItemsPropolis.class);
        if (pipe == null) {
            return;
        }
        pipe.pipeLogic.handleGenomeFilterChange(packet);
    }

    private static void onRequestFilterSet(EntityPlayer player, PacketRequestFilterSet packet) {
        PipeItemsPropolis pipe = PipeHelper.getPipe(player.field_70170_p, packet.posX, packet.posY, packet.posZ, PipeItemsPropolis.class);
        if (pipe == null) {
            return;
        }
        pipe.pipeLogic.sendFilterSet(player);
    }
}

