/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.block;

import com.cricketcraft.chisel.api.ICarvable;
import com.cricketcraft.chisel.api.carving.CarvableHelper;
import com.cricketcraft.chisel.api.carving.IVariationInfo;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import team.chisel.Chisel;
import team.chisel.block.tileentity.TileEntityPresent;

public class BlockPresent
extends Block
implements ICarvable {
    public CarvableHelper carverHelper = new CarvableHelper(this);
    private float minX = 0.0625f;
    private float minY;
    private float minZ = 0.0625f;
    private float maxX = 0.9375f;
    private float maxY = 0.875f;
    private float maxZ = 0.9375f;

    public BlockPresent() {
        super(Material.field_151575_d);
        this.func_149676_a(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String getModelTexture(int type) {
        return "textures/blocks/present/presentChest" + type;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityPresent te = (TileEntityPresent)world.func_147438_o(x, y, z);
        world.func_72921_c(x, y, z, stack.func_77960_j(), 3);
        te.setRotation(heading);
        te.findConnections();
        if (te.isConnected()) {
            TileEntityPresent other = te.getConnection();
            other.setRotation(heading);
        }
        world.func_147471_g(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block present, int meta) {
        TileEntityPresent tileEntityPresent = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (tileEntityPresent != null) {
            for (int c = 0; c < tileEntityPresent.getTrueSizeInventory(); ++c) {
                ItemStack itemStack = tileEntityPresent.getTrueStackInSlot(c);
                if (itemStack == null) continue;
                this.func_149642_a(world, x, y, z, itemStack);
            }
            world.func_147453_f(x, y, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, (Block)this, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int hitX, float hitY, float hitZ, float p_149727_9_) {
        if (!world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            if (!world.field_72995_K) {
                player.openGui((Object)Chisel.instance, 2, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityPresent) {
            return this.getBoundingBox((TileEntityPresent)world.func_147438_o(x, y, z));
        }
        return null;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityPresent) {
            return this.getBoundingBox((TileEntityPresent)world.func_147438_o(x, y, z));
        }
        return null;
    }

    public AxisAlignedBB getBoundingBox(TileEntityPresent me) {
        if (me == null) {
            return AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        }
        int x = me.field_145851_c;
        int y = me.field_145848_d;
        int z = me.field_145849_e;
        if (me.isConnected()) {
            ForgeDirection dir = me.getConnectionDir();
            if (dir == ForgeDirection.EAST || me.isParent() && dir == ForgeDirection.SOUTH || !me.isParent() && dir == ForgeDirection.SOUTH) {
                return AxisAlignedBB.func_72330_a((double)((float)x + this.minX), (double)((float)y + this.minY), (double)((float)z + this.minZ), (double)((float)x + this.maxX + (float)dir.offsetX), (double)((float)y + this.maxY), (double)((float)z + this.maxZ + (float)dir.offsetZ));
            }
            return AxisAlignedBB.func_72330_a((double)((float)(x + dir.offsetX) + this.minX), (double)((float)y + this.minY), (double)((float)(z + dir.offsetZ) + this.minZ), (double)((float)x + this.maxX), (double)((float)y + this.maxY), (double)((float)z + this.maxZ));
        }
        return AxisAlignedBB.func_72330_a((double)((float)x + this.minX), (double)((float)y + this.minY), (double)((float)z + this.minZ), (double)((float)x + this.maxX), (double)((float)y + this.maxY), (double)((float)z + this.maxZ));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityPresent te = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (!te.isConnected()) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9365f);
        } else {
            ForgeDirection dir = te.getConnectionDir();
            switch (dir) {
                case EAST: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9365f);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9365f);
                    break;
                }
                case SOUTH: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9365f);
                    break;
                }
                default: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9365f);
                }
            }
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityPresent();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int strength) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPresent) {
            return Container.func_94526_b((IInventory)((TileEntityPresent)te));
        }
        return 0;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("planks_oak");
    }

    @Override
    public IVariationInfo getManager(IBlockAccess world, int x, int y, int z, int metadata) {
        return this.carverHelper.getVariation(metadata);
    }

    @Override
    public IVariationInfo getManager(int meta) {
        return this.carverHelper.getVariation(meta);
    }
}

