/*
 * Decompiled with CFR 0.152.
 */
package coint.commands;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.NBTUtils;
import serverutils.ranks.Ranks;

public class CommandFeed
extends CommandBase {
    private static final String TAG_LAST_FEED_MS = "cointcore_feed_last_ms";

    public String func_71517_b() {
        return "feed";
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            return Ranks.INSTANCE.getPermission(player.func_146103_bH(), "command.cointcore.feed", false).getBoolean();
        }
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/feed";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayer player = (EntityPlayer)sender;
        if (this.isOnCooldown(sender, player)) {
            return;
        }
        player.func_71024_bL().func_75122_a(20, 20.0f);
        this.applyNutritionMax(player);
        this.sendSuccess(sender, "\u0413\u043e\u043b\u043e\u0434 \u0432\u043e\u0441\u043f\u043e\u043b\u043d\u0435\u043d, \u043c\u0438\u043b\u043e\u0440\u0434");
    }

    private boolean isOnCooldown(ICommandSender sender, EntityPlayer player) {
        NBTTagCompound persisted = NBTUtils.getPersistedData((EntityPlayer)player, (boolean)true);
        long cooldownTicks = RankConfigAPI.get((EntityPlayerMP)((EntityPlayerMP)player), (String)"cointcore.feed.cooldown").getLong();
        if (cooldownTicks <= 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long lastUse = persisted.func_74763_f(TAG_LAST_FEED_MS);
        long elapsed = now - lastUse;
        long cooldownMs = Ticks.get((long)cooldownTicks).millis();
        if (lastUse > 0L && elapsed < cooldownMs) {
            long remainingSeconds = (cooldownMs - elapsed + 999L) / 1000L;
            this.sendError(sender, "\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u043e\u043a\u0443\u0448\u0430\u0442\u044c \u0447\u0435\u0440\u0435\u0437 " + this.formatDuration(remainingSeconds));
            return true;
        }
        persisted.func_74772_a(TAG_LAST_FEED_MS, now);
        return false;
    }

    private void sendError(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        sender.func_145747_a((IChatComponent)msg);
    }

    private void sendSuccess(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        sender.func_145747_a((IChatComponent)msg);
    }

    private void applyNutritionMax(EntityPlayer player) {
        try {
            Class<?> playerDataHandler = Class.forName("ca.wescook.nutrition.data.PlayerDataHandler");
            Class<?> nutrientList = Class.forName("ca.wescook.nutrition.nutrients.NutrientList");
            Class<?> nutrientClass = Class.forName("ca.wescook.nutrition.nutrients.Nutrient");
            Class<?> nutrientManagerClass = Class.forName("ca.wescook.nutrition.data.NutrientManager");
            Object manager = playerDataHandler.getMethod("getForPlayer", EntityPlayer.class).invoke(null, player);
            if (manager == null) {
                return;
            }
            List nutrients = (List)nutrientList.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            Method setMethod = nutrientManagerClass.getMethod("set", nutrientClass, Float.class);
            for (Object nutrient : nutrients) {
                setMethod.invoke(manager, nutrient, Float.valueOf(100.0f));
            }
            try {
                playerDataHandler.getMethod("setForPlayer", EntityPlayer.class, nutrientManagerClass, Boolean.TYPE).invoke(null, player, manager, true);
            }
            catch (NoSuchMethodException ignored) {
                playerDataHandler.getMethod("setForPlayer", EntityPlayer.class, nutrientManagerClass).invoke(null, player, manager);
            }
            nutrientManagerClass.getMethod("update", new Class[0]).invoke(manager, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "0 \u0441\u0435\u043a\u0443\u043d\u0434";
        }
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        if (minutes > 0L && remainingSeconds > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442") + " " + this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (minutes > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        return this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
    }

    private String formatUnit(long value, String one, String few, String many) {
        long mod100 = value % 100L;
        long mod10 = value % 10L;
        String word = mod100 >= 11L && mod100 <= 14L ? many : (mod10 == 1L ? one : (mod10 >= 2L && mod10 <= 4L ? few : many));
        return value + " " + word;
    }
}

