/*
 * Decompiled with CFR 0.152.
 */
package coint.commands;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.NBTUtils;
import serverutils.ranks.Ranks;

public class CommandHeal
extends CommandBase {
    private static final String TAG_LAST_HEAL_MS = "cointcore_heal_last_ms";

    public String func_71517_b() {
        return "heal";
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            return Ranks.INSTANCE.getPermission(player.func_146103_bH(), "command.cointcore.heal", false).getBoolean();
        }
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/heal";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayer player = (EntityPlayer)sender;
        if (this.isOnCooldown(sender, player)) {
            return;
        }
        player.func_70691_i(Float.MAX_VALUE);
        this.clearNegativeEffects(player);
        this.sendSuccess(sender, "\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e, \u0432\u0441\u0435 \u044d\u0444\u0444\u0435\u043a\u0442\u044b \u0441\u043d\u044f\u0442\u044b");
    }

    private boolean isOnCooldown(ICommandSender sender, EntityPlayer player) {
        NBTTagCompound persisted = NBTUtils.getPersistedData((EntityPlayer)player, (boolean)true);
        long cooldownTicks = RankConfigAPI.get((EntityPlayerMP)((EntityPlayerMP)player), (String)"cointcore.heal.cooldown").getLong();
        if (cooldownTicks <= 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long lastUse = persisted.func_74763_f(TAG_LAST_HEAL_MS);
        long elapsed = now - lastUse;
        long cooldownMs = Ticks.get((long)cooldownTicks).millis();
        if (lastUse > 0L && elapsed < cooldownMs) {
            long remainingSeconds = (cooldownMs - elapsed + 999L) / 1000L;
            this.sendError(sender, "\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u0446\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 " + this.formatDuration(remainingSeconds));
            return true;
        }
        persisted.func_74772_a(TAG_LAST_HEAL_MS, now);
        return false;
    }

    private void clearNegativeEffects(EntityPlayer player) {
        Collection effects = player.func_70651_bq();
        if (effects.isEmpty()) {
            return;
        }
        for (PotionEffect effect : new ArrayList(effects)) {
            if (Potion.field_76425_a[effect.func_76456_a()] == null) continue;
            player.func_82170_o(effect.func_76456_a());
        }
    }

    private void sendError(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        sender.func_145747_a((IChatComponent)msg);
    }

    private void sendSuccess(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        sender.func_145747_a((IChatComponent)msg);
    }

    private String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "0 \u0441\u0435\u043a\u0443\u043d\u0434";
        }
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        if (minutes > 0L && remainingSeconds > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442") + " " + this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (minutes > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        return this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
    }

    private String formatUnit(long value, String one, String few, String many) {
        long mod100 = value % 100L;
        long mod10 = value % 10L;
        String word = mod100 >= 11L && mod100 <= 14L ? many : (mod10 == 1L ? one : (mod10 >= 2L && mod10 <= 4L ? few : many));
        return value + " " + word;
    }
}

