/*
 * Decompiled with CFR 0.152.
 */
package coint.commands;

import coint.kit.KitDefinition;
import coint.kit.KitManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.ranks.Ranks;

public class CommandKit
extends CommandBase {
    private static final Pattern KIT_NAME = Pattern.compile("^[a-z0-9_-]{1,32}$");
    private static final String TAG_KIT_COOLDOWNS = "cointcore_kit_cooldowns";

    public CommandKit(MinecraftServer server) {
        PermissionAPI.registerNode((String)"cointcore.command.kit.create", (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"CointCore kit create");
        PermissionAPI.registerNode((String)"cointcore.command.kit.claim", (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"CointCore kit claim");
        PermissionAPI.registerNode((String)"cointcore.command.kit.list", (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"CointCore kit list");
        PermissionAPI.registerNode((String)"cointcore.command.kit.delete", (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"CointCore kit delete");
        if (server != null) {
            for (String name : KitManager.getKitNames(server)) {
                PermissionAPI.registerNode((String)("cointcore.kit." + name), (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)("CointCore kit: " + name));
            }
        }
    }

    public String func_71517_b() {
        return "kit";
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/kit create <name> [cooldown] | /kit claim <name> | /kit list | /kit delete <name>";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandKit.func_71530_a((String[])args, (String[])new String[]{"create", "claim", "list", "delete"});
        }
        if (args.length == 2 && ("claim".equalsIgnoreCase(args[0]) || "create".equalsIgnoreCase(args[0]) || "delete".equalsIgnoreCase(args[0]))) {
            Collection<String> names = KitManager.getKitNames(MinecraftServer.func_71276_C());
            return CommandKit.func_71530_a((String[])args, (String[])names.toArray(new String[0]));
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        String name;
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String sub = args[0].toLowerCase();
        String string = name = args.length > 1 ? args[1].toLowerCase() : null;
        if (("create".equals(sub) || "claim".equals(sub) || "delete".equals(sub)) && name == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (name != null && !KIT_NAME.matcher(name).matches()) {
            this.sendError(sender, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043d\u0430\u0431\u043e\u0440\u0430");
            return;
        }
        if ("create".equals(sub)) {
            if (!this.hasPermission((EntityPlayer)player, "cointcore.command.kit.create")) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            long cooldownTicks = this.parseCooldown(sender, args);
            if (cooldownTicks < 0L) {
                return;
            }
            List<ItemStack> items = this.captureItems((EntityPlayer)player);
            if (items.isEmpty()) {
                this.sendError(sender, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043d\u0430\u0431\u043e\u0440\u0430: \u0441\u0443\u043d\u0434\u0443\u043a \u0438\u043b\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0432 \u0440\u0443\u043a\u0435");
                return;
            }
            KitDefinition kit = new KitDefinition(name, items, cooldownTicks);
            KitManager.putKit(MinecraftServer.func_71276_C(), kit);
            this.registerKitPermission(name);
            this.sendSuccess(sender, "\u041d\u0430\u0431\u043e\u0440 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d: " + name);
            return;
        }
        if ("claim".equals(sub)) {
            KitDefinition kit = KitManager.getKit(MinecraftServer.func_71276_C(), name);
            if (kit == null) {
                this.sendError(sender, "\u041d\u0430\u0431\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + name);
                return;
            }
            if (!this.hasPermission((EntityPlayer)player, "cointcore.command.kit.claim") || !this.hasPermission((EntityPlayer)player, "cointcore.kit." + name)) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            if (this.isOnCooldown(sender, (EntityPlayer)player, kit)) {
                return;
            }
            if (!this.canFitAll((EntityPlayer)player, kit.getItems())) {
                this.sendError(sender, "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u043f\u043e\u043b\u043e\u043d, \u043d\u0430\u0431\u043e\u0440 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d");
                return;
            }
            for (ItemStack stack : kit.getItems()) {
                this.giveItem((EntityPlayer)player, stack.func_77946_l());
            }
            this.sendSuccess(sender, "\u041d\u0430\u0431\u043e\u0440 \u043f\u043e\u043b\u0443\u0447\u0435\u043d: " + name);
            return;
        }
        if ("list".equals(sub)) {
            if (!this.hasPermission((EntityPlayer)player, "cointcore.command.kit.list")) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            Collection<String> names = KitManager.getKitNames(MinecraftServer.func_71276_C());
            if (names.isEmpty()) {
                this.sendError(sender, "\u041d\u0430\u0431\u043e\u0440\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
                return;
            }
            this.sendSuccess(sender, "\u041d\u0430\u0431\u043e\u0440\u044b: " + String.join((CharSequence)", ", names));
            return;
        }
        if ("delete".equals(sub)) {
            if (!this.hasPermission((EntityPlayer)player, "cointcore.command.kit.delete")) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            KitDefinition kit = KitManager.getKit(MinecraftServer.func_71276_C(), name);
            if (kit == null) {
                this.sendError(sender, "\u041d\u0430\u0431\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + name);
                return;
            }
            KitManager.removeKit(MinecraftServer.func_71276_C(), name);
            this.sendSuccess(sender, "\u041d\u0430\u0431\u043e\u0440 \u0443\u0434\u0430\u043b\u0435\u043d: " + name);
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    private List<ItemStack> captureItems(EntityPlayer player) {
        IInventory inventory = this.getTargetInventory(player);
        if (inventory != null) {
            return this.captureFromInventory(inventory);
        }
        ItemStack held = player.func_70694_bm();
        if (held != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(held.func_77946_l());
            return items;
        }
        return new ArrayList<ItemStack>();
    }

    private IInventory getTargetInventory(EntityPlayer player) {
        float yaw = player.field_70177_z;
        float pitch = player.field_70125_A;
        float yawRad = (float)Math.toRadians(-yaw) - (float)Math.PI;
        float pitchRad = (float)Math.toRadians(-pitch);
        double cosPitch = MathHelper.func_76134_b((float)pitchRad);
        double sinPitch = MathHelper.func_76126_a((float)pitchRad);
        double cosYaw = MathHelper.func_76134_b((float)yawRad);
        double sinYaw = MathHelper.func_76126_a((float)yawRad);
        Vec3 start = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 look = Vec3.func_72443_a((double)(sinYaw * cosPitch), (double)sinPitch, (double)(cosYaw * cosPitch));
        Vec3 end = start.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        MovingObjectPosition hit = player.field_70170_p.func_72933_a(start, end);
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return null;
        }
        TileEntity tile = player.field_70170_p.func_147438_o(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        if (tile instanceof IInventory) {
            return (IInventory)tile;
        }
        return null;
    }

    private List<ItemStack> captureFromInventory(IInventory inventory) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            items.add(stack.func_77946_l());
        }
        return items;
    }

    private void giveItem(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_70099_a(stack, 0.0f);
        }
    }

    private boolean canFitAll(EntityPlayer player, List<ItemStack> items) {
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack[] slots = new ItemStack[inventory.field_70462_a.length];
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            ItemStack existing = inventory.field_70462_a[i];
            slots[i] = existing == null ? null : existing.func_77946_l();
        }
        for (ItemStack stack : items) {
            if (stack == null) continue;
            ItemStack remaining = stack.func_77946_l();
            if (remaining.field_77994_a <= 0) continue;
            this.mergeIntoExisting(slots, inventory, remaining);
            if (remaining.field_77994_a > 0) {
                this.fillEmptySlots(slots, inventory, remaining);
            }
            if (remaining.field_77994_a <= 0) continue;
            return false;
        }
        return true;
    }

    private void mergeIntoExisting(ItemStack[] slots, InventoryPlayer inventory, ItemStack remaining) {
        if (!remaining.func_77985_e()) {
            return;
        }
        for (int i = 0; i < slots.length; ++i) {
            int max;
            ItemStack existing = slots[i];
            if (existing == null || !existing.func_77985_e() || !existing.func_77969_a(remaining) || !ItemStack.func_77970_a((ItemStack)existing, (ItemStack)remaining) || existing.field_77994_a >= (max = Math.min(existing.func_77976_d(), inventory.func_70297_j_()))) continue;
            int space = max - existing.field_77994_a;
            int toMove = Math.min(space, remaining.field_77994_a);
            existing.field_77994_a += toMove;
            remaining.field_77994_a -= toMove;
            if (remaining.field_77994_a > 0) continue;
            return;
        }
    }

    private void fillEmptySlots(ItemStack[] slots, InventoryPlayer inventory, ItemStack remaining) {
        for (int i = 0; i < slots.length; ++i) {
            if (slots[i] != null) continue;
            int max = Math.min(remaining.func_77976_d(), inventory.func_70297_j_());
            int toMove = Math.min(max, remaining.field_77994_a);
            ItemStack copy = remaining.func_77946_l();
            copy.field_77994_a = toMove;
            slots[i] = copy;
            remaining.field_77994_a -= toMove;
            if (remaining.field_77994_a > 0) continue;
            return;
        }
    }

    private boolean hasPermission(EntityPlayer player, String node) {
        return Ranks.INSTANCE.getPermission(player.func_146103_bH(), node, true).getBoolean();
    }

    private long parseCooldown(ICommandSender sender, String[] args) {
        if (args.length < 3) {
            return 0L;
        }
        try {
            return Ticks.get((String)args[2]).ticks();
        }
        catch (Exception ex) {
            this.sendError(sender, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u0443\u043b\u0434\u0430\u0443\u043d\u0430");
            return -1L;
        }
    }

    private boolean isOnCooldown(ICommandSender sender, EntityPlayer player, KitDefinition kit) {
        long cooldownTicks = kit.getCooldownTicks();
        if (cooldownTicks <= 0L) {
            return false;
        }
        NBTTagCompound persisted = NBTUtils.getPersistedData((EntityPlayer)player, (boolean)true);
        NBTTagCompound kitsTag = persisted.func_74775_l(TAG_KIT_COOLDOWNS);
        long lastUse = kitsTag.func_74763_f(kit.getName());
        long now = System.currentTimeMillis();
        long elapsed = now - lastUse;
        long cooldownMs = Ticks.get((long)cooldownTicks).millis();
        if (lastUse > 0L && elapsed < cooldownMs) {
            long remainingSeconds = (cooldownMs - elapsed + 999L) / 1000L;
            this.sendError(sender, "\u041d\u0430\u0431\u043e\u0440 \u0431\u0443\u0434\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0447\u0435\u0440\u0435\u0437 " + this.formatDuration(remainingSeconds));
            return true;
        }
        kitsTag.func_74772_a(kit.getName(), now);
        persisted.func_74782_a(TAG_KIT_COOLDOWNS, (NBTBase)kitsTag);
        return false;
    }

    private void registerKitPermission(String name) {
        PermissionAPI.registerNode((String)("cointcore.kit." + name), (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)("CointCore kit: " + name));
    }

    private void sendSuccess(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        sender.func_145747_a((IChatComponent)msg);
    }

    private void sendError(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        sender.func_145747_a((IChatComponent)msg);
    }

    private String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "0 \u0441\u0435\u043a\u0443\u043d\u0434";
        }
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        if (minutes > 0L && remainingSeconds > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442") + " " + this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (minutes > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        return this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
    }

    private String formatUnit(long value, String one, String few, String many) {
        long mod100 = value % 100L;
        long mod10 = value % 10L;
        String word = mod100 >= 11L && mod100 <= 14L ? many : (mod10 == 1L ? one : (mod10 >= 2L && mod10 <= 4L ? few : many));
        return value + " " + word;
    }
}

