/*
 * Decompiled with CFR 0.152.
 */
package coint.commands;

import coint.util.ItemUtil;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.NBTUtils;
import serverutils.ranks.Ranks;

public class CommandRepair
extends CommandBase {
    private static final String ARG_HAND = "hand";
    private static final String ARG_ALL = "all";
    private static final String TAG_LAST_REPAIR_MS = "cointcore_repair_last_ms";

    public String func_71517_b() {
        return "repair";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            return Ranks.INSTANCE.getPermission(player.func_146103_bH(), "command.cointcore.repair", false).getBoolean();
        }
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/repair [hand|all]";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandRepair.func_71530_a((String[])args, (String[])new String[]{ARG_HAND, ARG_ALL});
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        int i;
        String mode;
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        String allowedMode = RankConfigAPI.get((EntityPlayerMP)((EntityPlayerMP)player), (String)"cointcore.repair.level").getString();
        if (allowedMode == null || allowedMode.isEmpty()) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        String string = mode = args.length == 0 ? allowedMode : args[0].toLowerCase();
        if (!ARG_HAND.equals(mode) && !ARG_ALL.equals(mode)) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (ARG_ALL.equals(mode) && ARG_HAND.equals(allowedMode)) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        NBTTagCompound persisted = NBTUtils.getPersistedData((EntityPlayer)player, (boolean)true);
        long cooldownTicks = RankConfigAPI.get((EntityPlayerMP)((EntityPlayerMP)player), (String)"cointcore.repair.cooldown").getLong();
        if (cooldownTicks > 0L) {
            long now = System.currentTimeMillis();
            long lastUse = persisted.func_74763_f(TAG_LAST_REPAIR_MS);
            long elapsed = now - lastUse;
            long cooldownMs = Ticks.get((long)cooldownTicks).millis();
            if (lastUse > 0L && elapsed < cooldownMs) {
                long remainingSeconds = (cooldownMs - elapsed + 999L) / 1000L;
                this.sendError(sender, "\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u043e\u0447\u0438\u043d\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0447\u0435\u0440\u0435\u0437 " + this.formatDuration(remainingSeconds));
                return;
            }
            persisted.func_74772_a(TAG_LAST_REPAIR_MS, now);
        }
        if (ARG_HAND.equals(mode)) {
            ItemUtil.Repair(player.func_70694_bm());
            this.sendSuccess(sender, "\u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u0432 \u0440\u0443\u043a\u0435 \u043f\u043e\u0447\u0438\u043d\u0435\u043d");
            return;
        }
        InventoryPlayer inventory = player.field_71071_by;
        for (i = 0; i < inventory.field_70462_a.length; ++i) {
            ItemUtil.Repair(inventory.field_70462_a[i]);
        }
        for (i = 0; i < inventory.field_70460_b.length; ++i) {
            ItemUtil.Repair(inventory.field_70460_b[i]);
        }
        this.sendSuccess(sender, "\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435 \u043f\u043e\u0447\u0438\u043d\u0435\u043d\u044b");
    }

    private void sendSuccess(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        sender.func_145747_a((IChatComponent)msg);
    }

    private void sendError(ICommandSender sender, String message) {
        ChatComponentText msg = new ChatComponentText(message);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        sender.func_145747_a((IChatComponent)msg);
    }

    private String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "0 \u0441\u0435\u043a\u0443\u043d\u0434";
        }
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        if (minutes > 0L && remainingSeconds > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442") + " " + this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (minutes > 0L) {
            return this.formatUnit(minutes, "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        return this.formatUnit(remainingSeconds, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
    }

    private String formatUnit(long value, String one, String few, String many) {
        long mod100 = value % 100L;
        long mod10 = value % 10L;
        String word = mod100 >= 11L && mod100 <= 14L ? many : (mod10 == 1L ? one : (mod10 >= 2L && mod10 <= 4L ? few : many));
        return value + " " + word;
    }
}

