/*
 * Decompiled with CFR 0.152.
 */
package coint.commands;

import coint.commands.warn.PlayerWarnsData;
import coint.commands.warn.Warn;
import coint.integration.serverutilities.SURanksManager;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.ranks.Ranks;

public class CommandWarn
extends CommandBase {
    public CommandWarn() {
        PermissionAPI.registerNode((String)"cointcore.command.warn", (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"CointCore warn permission");
    }

    public String func_71517_b() {
        return "warn";
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            return Ranks.INSTANCE.getPermission(player.func_146103_bH(), "cointcore.command.warn", false).getBoolean();
        }
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/warn add <player> 'reason' | /warn get <player>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String sub = args[0].toLowerCase();
        String playerName = args[1].toLowerCase();
        ForgePlayer player = SURanksManager.getInstance().getUniverse().getPlayer((CharSequence)playerName);
        if (player == null) {
            throw new PlayerNotFoundException();
        }
        switch (sub) {
            case "add": {
                if (args.length < 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                String reason = args[2];
                Warn warn = new Warn(sender, reason);
                if (player.isOnline()) {
                    PlayerWarnsData warnsData = PlayerWarnsData.get((EntityPlayer)player.getPlayer());
                    warnsData.add(warn);
                } else {
                    PlayerWarnsData.addOffline(player.getId(), warn);
                }
            }
            case "get": {
                List<Warn> warns;
                if (player.isOnline()) {
                    PlayerWarnsData warnsData = PlayerWarnsData.get((EntityPlayer)player.getPlayer());
                    warns = warnsData.get();
                } else {
                    warns = PlayerWarnsData.getOffline(player.getId());
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(playerName + ": " + warns.size() + " warns"));
                for (Warn warn : warns) {
                    Instant when = Instant.parse(warn.timestamp);
                    ZonedDateTime zdt = when.atZone(ZoneId.of("Europe/Moscow"));
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
                    sender.func_145747_a((IChatComponent)new ChatComponentText(warn.warner + ":" + zdt.format(formatter) + " - " + warn.reason));
                }
                break;
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }
}

