/*
 * Decompiled with CFR 0.152.
 */
package coint.commands.warn;

import coint.CointCore;
import coint.commands.warn.Warn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerWarnsData
implements IExtendedEntityProperties {
    public static String EXT_PROP = "cointcore";
    List<Warn> warns;

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound props = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Warn warn : this.warns) {
            NBTTagCompound warnCompound = new NBTTagCompound();
            warnCompound.func_74778_a("warner", warn.warner);
            warnCompound.func_74778_a("reason", warn.reason);
            warnCompound.func_74778_a("timestamp", warn.timestamp);
            list.func_74742_a((NBTBase)warnCompound);
        }
        props.func_74782_a("warns", (NBTBase)list);
        compound.func_74782_a(EXT_PROP, (NBTBase)props);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound props = (NBTTagCompound)compound.func_74781_a(EXT_PROP);
        if (props != null && props.func_150297_b("warns", 9)) {
            NBTTagList warnsList = props.func_150295_c("warns", 10);
            this.warns.clear();
            for (int i = 0; i < warnsList.func_74745_c(); ++i) {
                NBTTagCompound warnCompound = warnsList.func_150305_b(i);
                Warn warn = new Warn();
                warn.warner = warnCompound.func_74779_i("warner");
                warn.reason = warnCompound.func_74779_i("reason");
                warn.timestamp = warnCompound.func_74779_i("timestamp");
                this.warns.add(warn);
            }
        }
    }

    public void init(Entity entity, World world) {
        this.warns = new ArrayList<Warn>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Warn> getOffline(UUID player) {
        File playerDataFile = new File("World/playerdata/" + player + ".dat");
        if (!playerDataFile.exists()) return null;
        try (FileInputStream fileInputStream = new FileInputStream(playerDataFile);){
            NBTTagCompound fullPlayerData = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            NBTTagCompound props = fullPlayerData.func_74775_l(EXT_PROP);
            if (props == null) return null;
            if (!props.func_150297_b("warns", 9)) return null;
            NBTTagList warnsList = props.func_150295_c("warns", 10);
            LinkedList<Warn> warns = new LinkedList<Warn>();
            for (int i = 0; i < warnsList.func_74745_c(); ++i) {
                NBTTagCompound warnCompound = warnsList.func_150305_b(i);
                Warn warn = new Warn();
                warn.warner = warnCompound.func_74779_i("warner");
                warn.reason = warnCompound.func_74779_i("reason");
                warn.timestamp = warnCompound.func_74779_i("timestamp");
                warns.add(warn);
            }
            LinkedList<Warn> linkedList = warns;
            return linkedList;
        }
        catch (Exception e) {
            CointCore.LOG.error(e.getMessage());
        }
        return null;
    }

    public static void addOffline(UUID player, Warn warn) {
        File playerDataFile = new File("World/playerdata/" + player + ".dat");
        if (playerDataFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(playerDataFile);){
                NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
                NBTTagCompound props = compound.func_74775_l(EXT_PROP);
                if (props != null) {
                    NBTTagList list = props.func_150295_c("warns", 9);
                    NBTTagCompound warnCompound = new NBTTagCompound();
                    warnCompound.func_74778_a("warner", warn.warner);
                    warnCompound.func_74778_a("reason", warn.reason);
                    warnCompound.func_74778_a("timestamp", warn.timestamp);
                    list.func_74742_a((NBTBase)warnCompound);
                    props.func_74782_a("warns", (NBTBase)list);
                    compound.func_74782_a(EXT_PROP, (NBTBase)props);
                    FileOutputStream fileOutputStream = new FileOutputStream(playerDataFile);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                CointCore.LOG.error(e.getMessage());
            }
        }
    }

    public static PlayerWarnsData get(EntityPlayer player) {
        return (PlayerWarnsData)player.getExtendedProperties(EXT_PROP);
    }

    public void add(Warn warn) {
        this.warns.add(warn);
    }

    public List<Warn> get() {
        return this.warns;
    }
}

