/*
 * Decompiled with CFR 0.152.
 */
package coint.core;

import coint.CointCore;
import coint.commands.CommandFeed;
import coint.commands.CommandHeal;
import coint.commands.CommandKit;
import coint.commands.CommandNightVision;
import coint.commands.CommandRepair;
import coint.commands.CommandSync;
import coint.commands.warn.WarnsRegister;
import coint.config.CointConfig;
import coint.core.ModuleManager;
import coint.integration.serverutilities.CointRankConfigs;
import coint.module.epochsync.EpochRegistry;
import coint.module.epochsync.EpochSyncModule;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy {
    protected final ModuleManager moduleManager = new ModuleManager();

    public void preInit(FMLPreInitializationEvent event) {
        CointConfig.init(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new CointRankConfigs());
        MinecraftForge.EVENT_BUS.register((Object)new WarnsRegister());
        CointCore.LOG.info(CointConfig.greeting);
        CointCore.LOG.info("CointCore GTNH version {} initializing...", new Object[]{"v1.3.5"});
        this.registerModules();
        this.moduleManager.preInit();
    }

    public void init(FMLInitializationEvent event) {
        this.moduleManager.init();
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.moduleManager.postInit();
        CointCore.LOG.info("CointCore GTNH initialized successfully");
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        EpochRegistry.init(event);
    }

    public void serverStarting(FMLServerStartingEvent event) {
        this.moduleManager.serverStarting();
        event.registerServerCommand((ICommand)new CommandSync());
        event.registerServerCommand((ICommand)new CommandRepair());
        event.registerServerCommand((ICommand)new CommandHeal());
        event.registerServerCommand((ICommand)new CommandFeed());
        event.registerServerCommand((ICommand)new CommandKit(event.getServer()));
        event.registerServerCommand((ICommand)new CommandNightVision());
        CointCore.LOG.debug("Registered server commands");
    }

    protected void registerModules() {
        this.moduleManager.registerModule(new EpochSyncModule());
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }
}

