/*
 * Decompiled with CFR 0.152.
 */
package coint.core;

import coint.CointCore;
import coint.integration.IIntegration;
import coint.module.IModule;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ModuleManager {
    private static final Logger LOG = CointCore.LOG;
    private final Map<String, IModule> modules = new HashMap<String, IModule>();
    private final List<IIntegration> integrations = new ArrayList<IIntegration>();

    public void registerModule(IModule module) {
        if (this.modules.containsKey(module.getId())) {
            LOG.warn("Module with id '{}' is already registered, skipping", new Object[]{module.getId()});
            return;
        }
        this.modules.put(module.getId(), module);
        LOG.info("Registered module: {} ({})", new Object[]{module.getName(), module.getId()});
    }

    public void registerIntegration(IIntegration integration) {
        this.integrations.add(integration);
        LOG.debug("Registered integration: {}", new Object[]{integration.getName()});
    }

    public IModule getModule(String id) {
        return this.modules.get(id);
    }

    public Map<String, IModule> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public void preInit() {
        for (IModule module : this.modules.values()) {
            if (!module.isEnabled()) continue;
            try {
                module.preInit();
                LOG.debug("PreInit completed for module: {}", new Object[]{module.getId()});
            }
            catch (Exception e) {
                LOG.error("Error during preInit of module {}: {}", new Object[]{module.getId(), e.getMessage(), e});
            }
        }
    }

    public void init() {
        for (IModule module : this.modules.values()) {
            if (!module.isEnabled()) continue;
            try {
                module.init();
                LOG.debug("Init completed for module: {}", new Object[]{module.getId()});
            }
            catch (Exception e) {
                LOG.error("Error during init of module {}: {}", new Object[]{module.getId(), e.getMessage(), e});
            }
        }
    }

    public void postInit() {
        for (IModule module : this.modules.values()) {
            if (!module.isEnabled()) continue;
            try {
                module.postInit();
                LOG.debug("PostInit completed for module: {}", new Object[]{module.getId()});
            }
            catch (Exception e) {
                LOG.error("Error during postInit of module {}: {}", new Object[]{module.getId(), e.getMessage(), e});
            }
        }
        for (IIntegration integration : this.integrations) {
            if (this.isModLoaded(integration.getModId())) {
                try {
                    integration.register();
                    LOG.info("Loaded integration: {}", new Object[]{integration.getName()});
                }
                catch (Exception e) {
                    LOG.error("Error loading integration {}: {}", new Object[]{integration.getName(), e.getMessage(), e});
                }
                continue;
            }
            LOG.debug("Skipping integration {} - mod {} not loaded", new Object[]{integration.getName(), integration.getModId()});
        }
    }

    public void serverStarting() {
        for (IModule module : this.modules.values()) {
            if (!module.isEnabled()) continue;
            try {
                module.serverStarting();
            }
            catch (Exception e) {
                LOG.error("Error during serverStarting of module {}: {}", new Object[]{module.getId(), e.getMessage(), e});
            }
        }
    }

    private boolean isModLoaded(String modId) {
        return Loader.isModLoaded((String)modId);
    }
}

