/*
 * Decompiled with CFR 0.152.
 */
package coint.integration.betterquesting;

import betterquesting.api.events.QuestEvent;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.storage.DBEntry;
import betterquesting.questing.party.PartyManager;
import coint.config.CointConfig;
import coint.integration.serverutilities.SURanksManager;
import coint.module.epochsync.EpochEntry;
import coint.module.epochsync.EpochRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BQEventListener {
    private static final Logger LOG = LogManager.getLogger(BQEventListener.class);

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onQuestComplete(QuestEvent event) {
        if (event.getType() != QuestEvent.Type.COMPLETED || event.getQuestIDs().isEmpty()) {
            return;
        }
        if (!CointConfig.autoSyncOnQuestComplete) {
            LOG.debug("Auto sync on quest complete is disabled");
            return;
        }
        UUID playerId = event.getPlayerID();
        LOG.info("Quest completion event for player {}, quest IDs: {}", new Object[]{playerId, event.getQuestIDs()});
        for (UUID questID : event.getQuestIDs()) {
            this.processQuestCompletion(playerId, questID);
        }
    }

    private void processQuestCompletion(UUID playerId, UUID questID) {
        LOG.debug("Processing quest completion: {}", new Object[]{questID});
        EpochEntry epoch = EpochRegistry.INST.getEpoch(questID);
        if (epoch == null) {
            LOG.debug("Quest {} is not an epoch quest (no mapping{} )", new Object[]{questID, CointConfig.autoParseRewardCommands ? " and no rank command found" : ""});
            return;
        }
        LOG.info("Quest {} triggers rank: {}", new Object[]{questID, epoch.rankName});
        this.assignRankToPlayerAndParty(playerId, epoch);
    }

    private void assignRankToPlayerAndParty(UUID playerId, EpochEntry epoch) {
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            LOG.warn("SURanksManager not initialized, cannot set rank");
            return;
        }
        IParty party = this.getPlayerParty(playerId);
        if (party != null && CointConfig.partySyncEnabled) {
            List members = party.getMembers();
            LOG.info("Assigning rank {} to {} party members", new Object[]{epoch, members.size()});
            for (UUID memberUUID : members) {
                this.assignRankToPlayer(ranksManager, memberUUID, epoch);
            }
        } else {
            this.assignRankToPlayer(ranksManager, playerId, epoch);
        }
    }

    private void assignRankToPlayer(SURanksManager ranksManager, UUID playerId, EpochEntry epoch) {
        try {
            ranksManager.setRank(playerId, epoch.rankName);
            String name = ranksManager.getUniverse().getPlayer(playerId).getName();
            String msg = epoch.epochUpMessage.replace("@p", name);
            MinecraftServer.func_71276_C().func_145747_a((IChatComponent)new ChatComponentText(msg));
            LOG.info("Successfully set rank {} for player {}", new Object[]{epoch.rankName, playerId});
        }
        catch (Exception e) {
            LOG.error("Error setting rank {} for player {}: {}", new Object[]{epoch.rankName, playerId, e.getMessage(), e});
        }
    }

    private IParty getPlayerParty(UUID playerId) {
        try {
            DBEntry entry = PartyManager.INSTANCE.getParty(playerId);
            return entry != null ? (IParty)entry.getValue() : null;
        }
        catch (Exception e) {
            LOG.debug("Could not get party for player {}: {}", new Object[]{playerId, e.getMessage()});
            return null;
        }
    }

    public EpochEntry getHighestPartyEpoch(IParty party) {
        if (party == null) {
            return null;
        }
        EpochEntry highestEpoch = null;
        int highestPriority = -1;
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            return null;
        }
        for (UUID memberUUID : party.getMembers()) {
            EpochEntry memberEpoch = this.getPlayerCurrentEpoch(memberUUID);
            if (memberEpoch == null || memberEpoch.priority <= highestPriority) continue;
            highestPriority = memberEpoch.priority;
            highestEpoch = memberEpoch;
        }
        return highestEpoch;
    }

    private EpochEntry getPlayerCurrentEpoch(UUID playerId) {
        SURanksManager ranksManager = SURanksManager.getInstance();
        if (ranksManager == null) {
            return null;
        }
        try {
            return ranksManager.getPlayerEpoch(playerId);
        }
        catch (Exception e) {
            LOG.debug("Could not get epoch for player {}: {}", new Object[]{playerId, e.getMessage()});
            return null;
        }
    }

    public void syncPlayerToParty(UUID playerId) {
        IParty party = this.getPlayerParty(playerId);
        if (party == null) {
            LOG.debug("Player {} is not in a party, nothing to sync", new Object[]{playerId});
            return;
        }
        EpochEntry partyEpoch = this.getHighestPartyEpoch(party);
        if (partyEpoch == null) {
            LOG.debug("Party has no epoch rank, nothing to sync for player {}", new Object[]{playerId});
            return;
        }
        EpochEntry playerEpoch = this.getPlayerCurrentEpoch(playerId);
        if (playerEpoch == null || partyEpoch.priority > playerEpoch.priority) {
            LOG.info("Syncing player {} to party epoch: {}", new Object[]{playerId, partyEpoch});
            this.assignRankToPlayer(SURanksManager.getInstance(), playerId, partyEpoch);
        } else {
            LOG.debug("Player {} already has equal or higher epoch: {}", new Object[]{playerId, playerEpoch});
        }
    }
}

