/*
 * Decompiled with CFR 0.152.
 */
package coint.integration.betterquesting;

import betterquesting.api.questing.party.IParty;
import coint.CointCore;
import coint.config.CointConfig;
import coint.integration.IIntegration;
import coint.integration.betterquesting.BQEventListener;
import coint.integration.betterquesting.PartyAccessor;
import coint.integration.betterquesting.PartyEventListener;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;

public class BQIntegration
implements IIntegration {
    public static final String MOD_ID = "betterquesting";
    private BQEventListener eventListener;
    private PartyEventListener partyEventListener;

    @Override
    public String getModId() {
        return MOD_ID;
    }

    @Override
    public boolean isAvailable() {
        return Loader.isModLoaded((String)MOD_ID);
    }

    @Override
    public void register() {
        this.eventListener = new BQEventListener();
        MinecraftForge.EVENT_BUS.register((Object)this.eventListener);
        CointCore.LOG.debug("Registered BQEventListener");
        this.partyEventListener = new PartyEventListener();
        FMLCommonHandler.instance().bus().register((Object)this.partyEventListener);
        CointCore.LOG.debug("Registered PartyEventListener");
        if (CointConfig.syncNewPartyMembers) {
            PartyAccessor.setOnPlayerJoinPartyCallback((playerId, party) -> {
                CointCore.LOG.debug("Mixin callback: player {} joined party", new Object[]{playerId});
                this.partyEventListener.onPlayerJoinParty((UUID)playerId, (IParty)party);
            });
            CointCore.LOG.debug("Registered party join mixin callback");
        }
    }

    @Override
    public String getName() {
        return "BetterQuesting Integration";
    }

    public BQEventListener getEventListener() {
        return this.eventListener;
    }

    public PartyEventListener getPartyEventListener() {
        return this.partyEventListener;
    }
}

