/*
 * Decompiled with CFR 0.152.
 */
package coint.kit;

import coint.kit.KitDefinition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public final class KitManager {
    private static final String KIT_FILE = "cointcore/kits.dat";
    private static final String TAG_KITS = "kits";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_COOLDOWN = "cooldownTicks";
    private static final Map<String, KitDefinition> KITS = new LinkedHashMap<String, KitDefinition>();
    private static boolean loaded = false;

    private KitManager() {
    }

    public static synchronized void loadIfNeeded(MinecraftServer server) {
        if (loaded) {
            return;
        }
        KITS.clear();
        File file = server.func_71209_f(KIT_FILE);
        if (!file.exists()) {
            loaded = true;
            return;
        }
        try {
            NBTTagCompound root = CompressedStreamTools.func_74797_a((File)file);
            if (root == null) {
                loaded = true;
                return;
            }
            NBTTagCompound kitsTag = root.func_74775_l(TAG_KITS);
            Set keys = kitsTag.func_150296_c();
            for (String name : keys) {
                NBTTagCompound kitTag = kitsTag.func_74775_l(name);
                KitDefinition kit = KitManager.readKit(name, kitTag);
                KITS.put(name, kit);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        loaded = true;
    }

    public static synchronized void save(MinecraftServer server) {
        File file = server.func_71209_f(KIT_FILE);
        file.getParentFile().mkdirs();
        NBTTagCompound root = new NBTTagCompound();
        NBTTagCompound kitsTag = new NBTTagCompound();
        for (Map.Entry<String, KitDefinition> entry : KITS.entrySet()) {
            kitsTag.func_74782_a(entry.getKey(), (NBTBase)KitManager.writeKit(entry.getValue()));
        }
        root.func_74782_a(TAG_KITS, (NBTBase)kitsTag);
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)root, (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void putKit(MinecraftServer server, KitDefinition kit) {
        KitManager.loadIfNeeded(server);
        KITS.put(kit.getName(), kit);
        KitManager.save(server);
    }

    public static synchronized KitDefinition getKit(MinecraftServer server, String name) {
        KitManager.loadIfNeeded(server);
        return KITS.get(name);
    }

    public static synchronized Collection<String> getKitNames(MinecraftServer server) {
        KitManager.loadIfNeeded(server);
        return new ArrayList<String>(KITS.keySet());
    }

    public static synchronized void removeKit(MinecraftServer server, String name) {
        KitManager.loadIfNeeded(server);
        if (KITS.remove(name) != null) {
            KitManager.save(server);
        }
    }

    private static KitDefinition readKit(String name, NBTTagCompound kitTag) {
        long cooldownTicks = kitTag.func_74763_f(TAG_COOLDOWN);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        NBTTagList list = kitTag.func_150295_c(TAG_ITEMS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            if (stack == null) continue;
            items.add(stack);
        }
        return new KitDefinition(name, items, cooldownTicks);
    }

    private static NBTTagCompound writeKit(KitDefinition kit) {
        NBTTagCompound kitTag = new NBTTagCompound();
        kitTag.func_74772_a(TAG_COOLDOWN, kit.getCooldownTicks());
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : kit.getItems()) {
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        kitTag.func_74782_a(TAG_ITEMS, (NBTBase)list);
        return kitTag;
    }
}

