/*
 * Decompiled with CFR 0.152.
 */
package coint.module.epochsync;

import betterquesting.api.utils.UuidConverter;
import coint.CointCore;
import coint.module.epochsync.EpochEntry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.libraries.com.google.common.reflect.TypeToken;

public class EpochRegistry {
    public static EpochRegistry INST;
    private static final String EPOCHS_FILE = "cointcore/server/epochs.json";
    public HashMap<UUID, EpochEntry> epochs;
    private MinecraftServer server;
    private Gson gson;
    private File epochsFile;

    private EpochRegistry(MinecraftServer s) {
        this.server = s;
        this.epochs = new LinkedHashMap<UUID, EpochEntry>();
        this.gson = new GsonBuilder().create();
        this.epochsFile = null;
    }

    public static void init(FMLServerAboutToStartEvent event) {
        INST = new EpochRegistry(event.getServer());
        INST.reload();
    }

    public void reload() {
        this.epochsFile = this.server.func_71209_f(EPOCHS_FILE);
        this.epochs.clear();
        try {
            if (!this.epochsFile.exists() && !this.epochsFile.createNewFile()) {
                CointCore.LOG.info("empty epochs config created");
                return;
            }
            FileReader reader = new FileReader(this.epochsFile);
            Type type = new TypeToken<List<EpochEntry>>(){}.getType();
            List rowEpochs = (List)this.gson.fromJson((Reader)reader, type);
            rowEpochs.stream().sorted(Comparator.comparingInt(EpochEntry::getPriority)).forEachOrdered(entry -> this.epochs.put(UuidConverter.decodeUuid((String)entry.questId), (EpochEntry)entry));
            CointCore.LOG.info("epochs loaded from config");
        }
        catch (IOException e) {
            CointCore.LOG.error((Object)e);
        }
    }

    private void saveDefaultEpochs() {
    }

    public boolean isEpoch(String rank) {
        boolean result = false;
        for (EpochEntry e : this.epochs.values()) {
            result = result || e.rankName.equals(rank);
        }
        return result;
    }

    public EpochEntry getEpoch(UUID quest) {
        return this.epochs.get(quest);
    }

    public EpochEntry getEpoch(String rank) {
        for (EpochEntry e : this.epochs.values()) {
            if (!e.rankName.equals(rank)) continue;
            return e;
        }
        return null;
    }
}

