/*
 * Decompiled with CFR 0.152.
 */
package coint.module.epochsync;

import coint.CointCore;
import coint.config.CointConfig;
import coint.integration.betterquesting.BQIntegration;
import coint.integration.serverutilities.SUIntegration;
import coint.module.IModule;

public class EpochSyncModule
implements IModule {
    public static final String ID = "epochsync";
    public static final String NAME = "Epoch Sync";
    private final BQIntegration bqIntegration = new BQIntegration();
    private final SUIntegration suIntegration = new SUIntegration();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void preInit() {
        CointCore.LOG.debug("EpochSync module preInit");
    }

    @Override
    public void init() {
        CointCore.LOG.debug("EpochSync module init");
    }

    @Override
    public void postInit() {
        if (!this.isEnabled()) {
            CointCore.LOG.info("EpochSync module is disabled");
            return;
        }
        if (this.bqIntegration.isAvailable()) {
            this.bqIntegration.register();
            CointCore.LOG.info("BetterQuesting integration enabled");
        } else {
            CointCore.LOG.warn("BetterQuesting not found, epoch sync will not work");
        }
        if (this.suIntegration.isAvailable()) {
            this.suIntegration.register();
            CointCore.LOG.info("ServerUtilities integration enabled");
        } else {
            CointCore.LOG.warn("ServerUtilities not found, rank management will not work");
        }
    }

    @Override
    public void serverStarting() {
        if (this.isEnabled() && this.suIntegration.isAvailable()) {
            this.suIntegration.registerCommands();
        }
    }

    @Override
    public boolean isEnabled() {
        return CointConfig.epochSyncEnabled;
    }

    public BQIntegration getBQIntegration() {
        return this.bqIntegration;
    }

    public SUIntegration getSUIntegration() {
        return this.suIntegration;
    }
}

