/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformerproxy;

import java.util.ArrayList;
import java.util.List;
import makamys.coretweaks.api.IWrapper;
import makamys.coretweaks.optimization.transformerproxy.ITransformerWrapper;
import makamys.coretweaks.optimization.transformerproxy.TransformerProxyGenerator;
import net.minecraft.launchwrapper.IClassTransformer;

public class TransformerProxy
implements IClassTransformer,
IWrapper<IClassTransformer> {
    protected IClassTransformer original;
    private List<ITransformerWrapper> wrappers = new ArrayList<ITransformerWrapper>();
    private int nextWrapper;

    public void addWrapper(ITransformerWrapper wrapper) {
        this.wrappers.add(0, wrapper);
    }

    public TransformerProxy(IClassTransformer original) {
        this.original = original;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        this.nextWrapper = -1;
        return this.invokeNextHandler(name, transformedName, basicClass);
    }

    public static TransformerProxy of(IClassTransformer transformer) throws Exception {
        Class<?> cls = TransformerProxyGenerator.generate(TransformerProxy.class, transformer.getClass());
        return (TransformerProxy)cls.getConstructor(IClassTransformer.class).newInstance(transformer);
    }

    @Override
    public IClassTransformer getOriginal() {
        return this.original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] invokeNextHandler(String name, String transformedName, byte[] basicClass) {
        ++this.nextWrapper;
        try {
            if (this.nextWrapper == this.wrappers.size()) {
                byte[] byArray = this.original.transform(name, transformedName, basicClass);
                return byArray;
            }
            byte[] byArray = this.wrappers.get(this.nextWrapper).wrapTransform(name, transformedName, basicClass, this);
            return byArray;
        }
        finally {
            --this.nextWrapper;
        }
    }

    public String toString() {
        String s = "TransformerProxy(";
        boolean first = true;
        for (ITransformerWrapper l : this.wrappers) {
            if (!first) {
                s = s + ";";
            }
            s = s + l.getClass().getSimpleName();
            first = false;
        }
        s = s + ")";
        return s;
    }
}

