/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.makamys.mclib.updatecheck;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import makamys.coretweaks.repackage.makamys.mclib.updatecheck.UpdateCheckLib;
import makamys.coretweaks.repackage.makamys.mclib.updatecheck.UpdateCheckTask;
import org.apache.commons.io.IOUtils;

public class ResultHTMLRenderer {
    private static final String TABLE_TEMPLATE = "<h1>%s</h1>\n<table>\n\t<thead>\n\t\t<th>%s</th>\n\t\t<th>%s</th>\n\t\t<th>%s</th>\n\t\t<th>%s</th>\n\t</thead>\n\t%s\n</table>\n\n";
    private static final String TABLE_ROW_TEMPLATE = "\t<tr>\n\t\t<td>%s</td>\n\t\t<td>%s</td>\n\t\t<td>%s</td>\n\t\t<td><a href=\"%s\">%s</a></td>\n\t</tr>";
    private static final String FIELD_NAME = "Name";
    private static final String FIELD_CURRENT_VERSION = "Installed version";
    private static final String FIELD_NEW_VERSION = "Latest version";
    private static final String FIELD_URL = "Update link";
    private static final String TABLE_TITLE_TEMPLATE = "%s updates";

    private boolean hasAnythingToDisplay() {
        return UpdateCheckLib.categories.values().stream().anyMatch(cat -> cat.results.stream().anyMatch(r -> r.isInteresting()));
    }

    public boolean render(File outFile) {
        if (!this.hasAnythingToDisplay()) {
            outFile.delete();
        } else {
            try (FileOutputStream out = new FileOutputStream(outFile);){
                String template = IOUtils.toString((InputStream)ResultHTMLRenderer.class.getClassLoader().getResourceAsStream("resources/mclib/updatecheck/updates.template.html"));
                String html = String.format(template, this.generateTables());
                IOUtils.write((String)html, (OutputStream)out, (String)"utf8");
                UpdateCheckLib.LOGGER.info("Wrote update check results to " + outFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private String generateTables() {
        StringBuffer tables = new StringBuffer();
        List<UpdateCheckLib.UpdateCategory> first = Arrays.asList(UpdateCheckLib.MODS, UpdateCheckLib.RESOURCE_PACKS);
        Stream.concat(first.stream(), UpdateCheckLib.categories.values().stream().sorted().filter(c -> !first.contains(c))).forEach(cat -> {
            List interestingResults = cat.results.stream().filter(r -> r.isInteresting()).collect(Collectors.toList());
            if (!interestingResults.isEmpty()) {
                String tableTitle = cat.displayName;
                String rows = "";
                for (UpdateCheckTask.Result result : interestingResults) {
                    String newVersionStr = result.newVersion != null ? result.newVersion.toString() : "<b>ERROR</b>";
                    rows = rows + String.format(TABLE_ROW_TEMPLATE, result.task.name, result.task.currentVersion, newVersionStr, result.task.homepage, result.task.homepage);
                }
                tables.append(String.format(TABLE_TEMPLATE, String.format(TABLE_TITLE_TEMPLATE, tableTitle), FIELD_NAME, FIELD_CURRENT_VERSION, FIELD_NEW_VERSION, FIELD_URL, rows));
            }
        });
        return tables.toString();
    }
}

