/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

public class InMemoryGDiffPatcher {
    private static final int BYTE = 1;
    private static final int UBYTE = 2;
    private static final int SHORT = 3;
    private static final int USHORT = 4;
    private static final int INT = 5;
    private static final int UINT = 6;
    private static final int LONG = 7;
    private static final int ULONG = 8;
    private static final int[] TYPE_LENGTHS = new int[]{0, 1, 1, 2, 2, 4, 4, 8, 8};
    private static final int[] COPY_POSITION_TYPES = new int[]{4, 4, 4, 5, 5, 5, 7};
    private static final int[] COPY_LENGTH_TYPES = new int[]{2, 4, 5, 2, 4, 5, 5};

    public static void patch(byte[] source, byte[] patch, byte[] dest) {
        int cmd;
        if (patch[0] != -47 || patch[1] != -1 || patch[2] != -47 || patch[3] != -1) {
            throw new IllegalArgumentException("wrong header");
        }
        if (patch[4] != 4) {
            throw new IllegalArgumentException("unsupported gdiff version: " + patch[5]);
        }
        int patchPos = 5;
        int destPos = 0;
        while (patchPos < patch.length && (cmd = Byte.toUnsignedInt(patch[patchPos])) != 0) {
            if (cmd >= 1 && cmd <= 248) {
                int lengthType = cmd < 247 ? 0 : (cmd == 247 ? 4 : 5);
                int lengthTypeLength = TYPE_LENGTHS[lengthType];
                int length = lengthType == 0 ? cmd : InMemoryGDiffPatcher.readValue(patch, patchPos + 1, lengthType);
                System.arraycopy(patch, patchPos + 1 + lengthTypeLength, dest, destPos, length);
                patchPos += 1 + lengthTypeLength + length;
                destPos += length;
                continue;
            }
            if (cmd >= 249 && cmd <= 254) {
                int positionType = COPY_POSITION_TYPES[cmd - 249];
                int positionTypeLength = TYPE_LENGTHS[positionType];
                int lengthType = COPY_LENGTH_TYPES[cmd - 249];
                int lengthTypeLength = TYPE_LENGTHS[lengthType];
                int position = InMemoryGDiffPatcher.readValue(patch, patchPos + 1, positionType);
                int length = InMemoryGDiffPatcher.readValue(patch, patchPos + 1 + positionTypeLength, lengthType);
                System.arraycopy(source, position, dest, destPos, length);
                patchPos += 1 + positionTypeLength + lengthTypeLength;
                destPos += length;
                continue;
            }
            throw new UnsupportedOperationException("long operand is not supported");
        }
    }

    private static int readValue(byte[] array, int offset, int type) {
        switch (type) {
            case 2: {
                return Byte.toUnsignedInt(array[offset]);
            }
            case 4: {
                return Byte.toUnsignedInt(array[offset]) << 8 | Byte.toUnsignedInt(array[offset + 1]);
            }
            case 5: {
                return Byte.toUnsignedInt(array[offset]) << 24 | Byte.toUnsignedInt(array[offset + 1]) << 16 | Byte.toUnsignedInt(array[offset + 2]) << 8 | Byte.toUnsignedInt(array[offset + 3]) << 0;
            }
        }
        throw new UnsupportedOperationException("unimplemented type: " + type);
    }
}

