/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.gui;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import lumien.custommainmenu.CustomMainMenu;
import lumien.custommainmenu.configuration.Alignment;
import lumien.custommainmenu.configuration.Config;
import lumien.custommainmenu.configuration.GuiConfig;
import lumien.custommainmenu.configuration.elements.Background;
import lumien.custommainmenu.configuration.elements.Button;
import lumien.custommainmenu.configuration.elements.Image;
import lumien.custommainmenu.configuration.elements.Panorama;
import lumien.custommainmenu.configuration.elements.SplashText;
import lumien.custommainmenu.configuration.elements.Text;
import lumien.custommainmenu.gui.GuiCustomButton;
import lumien.custommainmenu.gui.GuiCustomLabel;
import lumien.custommainmenu.gui.GuiCustomWrappedButton;
import lumien.custommainmenu.gui.GuiFakeMain;
import lumien.custommainmenu.lib.actions.ActionOpenLink;
import lumien.custommainmenu.lib.textures.ITexture;
import lumien.custommainmenu.util.GlStateManager;
import lumien.custommainmenu.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class GuiCustom
extends GuiScreen
implements GuiYesNoCallback {
    public static Config config;
    int buttonCounter;
    int panoramaTimer;
    ArrayList<GuiCustomLabel> textLabels;
    private ITexture[] titlePanoramaPaths;
    public Object beingChecked;
    public final GuiConfig guiConfig;
    final Random rand;
    protected DynamicTexture viewportTexture;
    protected ResourceLocation field_110351_G;
    protected String splashText;
    protected int field_92024_r;
    protected int field_92023_s;
    protected int field_92022_t;
    protected int field_92021_u;
    protected int field_92020_v;
    protected int field_92019_w;
    FontRenderer fontRenderer;
    private boolean loadedSplashText;

    public GuiCustom(GuiConfig guiConfig) {
        this.guiConfig = guiConfig;
        this.rand = new Random();
        this.loadedSplashText = false;
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (p_73869_2_ == 1) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    private void loadSplashTexts() {
        if (this.guiConfig.splashText != null) {
            String texts = this.guiConfig.splashText.texts.get();
            String[] seperateLines = texts.split("\n");
            this.splashText = seperateLines[this.rand.nextInt(seperateLines.length)];
        }
    }

    public void func_73866_w_() {
        if (!this.loadedSplashText && this.guiConfig.splashText != null) {
            if (this.guiConfig.splashText.synced) {
                this.splashText = CustomMainMenu.INSTANCE.config.getGUI((String)"mainmenu").splashText;
            } else {
                this.loadSplashTexts();
            }
            this.loadedSplashText = true;
        }
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.textLabels = new ArrayList();
        this.buttonCounter = 0;
        this.viewportTexture = new DynamicTexture(256, 256);
        this.field_110351_G = this.field_146297_k.func_110434_K().func_110578_a("background", this.viewportTexture);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 11 && calendar.get(5) == 9) {
            this.splashText = "Happy birthday, ez!";
        } else if (calendar.get(2) + 1 == 6 && calendar.get(5) == 1) {
            this.splashText = "Happy birthday, Notch!";
        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            this.splashText = "Merry X-mas!";
        } else if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            this.splashText = "Happy new year!";
        } else if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
            this.splashText = "OOoooOOOoooo! Spooky!";
        }
        int idCounter = 6000;
        for (Button b : this.guiConfig.customButtons) {
            if (b.wrappedButtonID != -1) {
                this.field_146292_n.add(this.alignButton(b, new GuiCustomWrappedButton(b.wrappedButtonID, b.wrappedButtonID, b)));
                continue;
            }
            this.field_146292_n.add(this.alignButton(b, new GuiCustomButton(idCounter, b)));
            ++idCounter;
        }
        for (Text t : this.guiConfig.customTexts) {
            this.textLabels.add(new GuiCustomLabel(this, t, this.modX(t.posX, t.alignment), this.modY(t.posY, t.alignment)));
        }
    }

    private GuiCustomButton alignButton(Button configButton, GuiCustomButton guiButton) {
        if (configButton != null) {
            guiButton.field_146128_h = this.modX(configButton.posX, configButton.alignment);
            guiButton.field_146129_i = this.modY(configButton.posY, configButton.alignment);
        }
        return guiButton;
    }

    public void func_73878_a(boolean result, int id) {
        if (result) {
            String link = null;
            Object object = this.beingChecked;
            if (object instanceof Button) {
                Button button = (Button)object;
                if (button.action instanceof ActionOpenLink) {
                    link = ((ActionOpenLink)button.action).getLink();
                }
            } else {
                object = this.beingChecked;
                if (object instanceof Text) {
                    Text text = (Text)object;
                    if (text.action instanceof ActionOpenLink) {
                        link = ((ActionOpenLink)text.action).getLink();
                    }
                }
            }
            if (link != null) {
                try {
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object2 = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object2, new URI(link));
                }
                catch (Throwable throwable) {
                    CustomMainMenu.INSTANCE.logger.error("Couldn't open link", throwable);
                }
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (GuiCustomLabel label : this.textLabels) {
                label.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int w;
        GlStateManager.disableBlend();
        Panorama panorama = this.guiConfig.panorama;
        Tessellator worldrenderer = Tessellator.field_78398_a;
        if (panorama != null) {
            this.titlePanoramaPaths = panorama.locations;
            GlStateManager.disableAlpha();
            this.renderSkybox(mouseX, mouseY, partialTicks);
            GlStateManager.enableAlpha();
            if (panorama.gradient) {
                this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -2130706433, 0xFFFFFF);
                this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0, Integer.MIN_VALUE);
            }
        } else {
            GL11.glBegin((int)7);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)this.field_146295_m, (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)this.field_146294_l, (float)this.field_146295_m, (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)this.field_146294_l, (float)0.0f, (float)0.0f);
            GL11.glEnd();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        Background background = this.guiConfig.background;
        if (background != null) {
            if (!background.ichBinEineSlideshow) {
                GlStateManager.enableBlend();
                background.image.bind();
                this.drawBackground(background.mode);
                GlStateManager.disableBlend();
            } else {
                background.slideShow.getCurrentResource1().bind();
                this.drawBackground(background.mode);
                if (background.slideShow.fading()) {
                    GlStateManager.enableBlend();
                    background.slideShow.getCurrentResource2().bind();
                    GlStateManager.color(1.0f, 1.0f, 1.0f, background.slideShow.getAlphaFade(partialTicks));
                    this.drawBackground(background.mode);
                    GlStateManager.disableBlend();
                    GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(770, 771);
        for (Image i : this.guiConfig.customImages) {
            int posX = this.modX(i.posX, i.alignment);
            int posY = this.modY(i.posY, i.alignment);
            if (i.ichBinEineSlideshow) {
                i.slideShow.getCurrentResource1().bind();
                RenderUtil.drawCompleteImage(posX, posY, i.width, i.height);
                if (!i.slideShow.fading()) continue;
                GlStateManager.enableBlend();
                i.slideShow.getCurrentResource2().bind();
                GlStateManager.color(1.0f, 1.0f, 1.0f, i.slideShow.getAlphaFade(partialTicks));
                RenderUtil.drawCompleteImage(posX, posY, i.width, i.height);
                GlStateManager.disableBlend();
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                continue;
            }
            if (i.hoverImage != null && mouseX >= posX && mouseX <= posX + i.width && mouseY >= posY && mouseY <= posY + i.height) {
                i.hoverImage.bind();
            } else {
                i.image.bind();
            }
            RenderUtil.drawCompleteImage(posX, posY, i.width, i.height);
        }
        GlStateManager.disableBlend();
        worldrenderer.func_78378_d(-1);
        SplashText splashText = this.guiConfig.splashText;
        if (splashText != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translate(this.modX(splashText.posX, splashText.alignment), this.modY(splashText.posY, splashText.alignment), 0.0f);
            GlStateManager.rotate(-20.0f, 0.0f, 0.0f, 1.0f);
            float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
            f1 = f1 * 100.0f / (float)(this.fontRenderer.func_78256_a(this.splashText) + 32);
            GlStateManager.scale(f1, f1, f1);
            this.func_73732_a(this.fontRenderer, this.splashText, 0, -8, splashText.color);
            GlStateManager.popMatrix();
        }
        for (GuiCustomLabel label : this.textLabels) {
            label.drawLabel(this.field_146297_k, mouseX, mouseY);
        }
        for (w = 0; w < this.field_146292_n.size(); ++w) {
            GlStateManager.resetColor();
            ((GuiButton)this.field_146292_n.get(w)).func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        for (GuiCustomLabel o : this.field_146292_n) {
            if (!(o instanceof GuiCustomButton)) continue;
            ((GuiCustomButton)((Object)o)).drawTooltip(this.field_146297_k, mouseX, mouseY);
        }
        for (w = 0; w < this.field_146293_o.size(); ++w) {
            ((GuiLabel)this.field_146293_o.get(w)).func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void drawBackground(Background.MODE mode) {
        int imageWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int imageHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int drawWidth = 0;
        int drawHeight = 0;
        float factorWidth = (float)this.field_146294_l / (float)imageWidth;
        float factorHeight = (float)this.field_146295_m / (float)imageHeight;
        switch (mode) {
            case FILL: {
                if (factorWidth > factorHeight) {
                    drawWidth = (int)((float)imageWidth * factorWidth);
                    drawHeight = (int)((float)imageHeight * factorWidth);
                } else {
                    drawWidth = (int)((float)imageWidth * factorHeight);
                    drawHeight = (int)((float)imageHeight * factorHeight);
                }
                RenderUtil.drawPartialImage(0, 0, 0, 0, drawWidth, drawHeight, imageWidth, imageHeight);
                break;
            }
            case STRETCH: {
                RenderUtil.drawCompleteImage(0, 0, this.field_146294_l, this.field_146295_m);
                break;
            }
            case CENTER: {
                RenderUtil.drawCompleteImage((int)((float)this.field_146294_l / 2.0f - (float)imageWidth / 2.0f), (int)((float)this.field_146295_m / 2.0f - (float)imageHeight / 2.0f), imageWidth, imageHeight);
                break;
            }
            case TILE: {
                int countX = (int)Math.ceil((float)this.field_146294_l / (float)imageWidth);
                int countY = (int)Math.ceil((float)this.field_146295_m / (float)imageHeight);
                for (int cX = 0; cX < countX; ++cX) {
                    for (int cY = 0; cY < countY; ++cY) {
                        RenderUtil.drawCompleteImage(cX * imageWidth, cY * imageHeight, imageWidth, imageHeight);
                    }
                }
                break;
            }
        }
    }

    protected void renderSkybox(int p_73971_1_, int p_73971_2_, float p_73971_3_) {
        this.field_146297_k.func_147110_a().func_147609_e();
        GlStateManager.viewport(0, 0, 256, 256);
        this.drawPanorama(p_73971_1_, p_73971_2_, p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.field_146297_k.func_147110_a().func_147610_a(true);
        GlStateManager.viewport(0, 0, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        Tessellator worldrenderer = Tessellator.field_78398_a;
        worldrenderer.func_78382_b();
        float f1 = this.field_146294_l > this.field_146295_m ? 120.0f / (float)this.field_146294_l : 120.0f / (float)this.field_146295_m;
        float f2 = (float)this.field_146295_m * f1 / 256.0f;
        float f3 = (float)this.field_146294_l * f1 / 256.0f;
        worldrenderer.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.field_146294_l;
        int l = this.field_146295_m;
        worldrenderer.func_78374_a(0.0, (double)l, (double)this.field_73735_i, (double)(0.5f - f2), (double)(0.5f + f3));
        worldrenderer.func_78374_a((double)k, (double)l, (double)this.field_73735_i, (double)(0.5f - f2), (double)(0.5f - f3));
        worldrenderer.func_78374_a((double)k, 0.0, (double)this.field_73735_i, (double)(0.5f + f2), (double)(0.5f - f3));
        worldrenderer.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(0.5f + f2), (double)(0.5f + f3));
        worldrenderer.func_78381_a();
    }

    private void drawPanorama(int p_73970_1_, int p_73970_2_, float p_73970_3_) {
        Tessellator worldrenderer = Tessellator.field_78398_a;
        GlStateManager.matrixMode(5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GlStateManager.matrixMode(5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        GlStateManager.disableCull();
        GlStateManager.depthMask(false);
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        int b0 = 8;
        for (int k = 0; k < b0 * b0; ++k) {
            GlStateManager.pushMatrix();
            float f1 = ((float)(k % b0) / (float)b0 - 0.5f) / 64.0f;
            float f2 = ((float)(k / b0) / (float)b0 - 0.5f) / 64.0f;
            float f3 = 0.0f;
            GlStateManager.translate(f1, f2, f3);
            float animationCounter = p_73970_3_;
            if (!this.guiConfig.panorama.animate) {
                animationCounter = 0.0f;
            }
            GlStateManager.rotate(MathHelper.func_76126_a((float)(((float)this.panoramaTimer + animationCounter) / 400.0f)) * 25.0f + 20.0f, 1.0f, 0.0f, 0.0f);
            GlStateManager.rotate(-((float)this.panoramaTimer + animationCounter) * 0.1f, 0.0f, 1.0f, 0.0f);
            for (int l = 0; l < 6; ++l) {
                GlStateManager.pushMatrix();
                if (l == 1) {
                    GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                }
                if (l == 2) {
                    GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                }
                if (l == 3) {
                    GlStateManager.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
                }
                if (l == 4) {
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                }
                if (l == 5) {
                    GlStateManager.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
                }
                this.titlePanoramaPaths[l].bind();
                worldrenderer.func_78382_b();
                worldrenderer.func_78384_a(0xFFFFFF, 255 / (k + 1));
                float f4 = 0.0f;
                worldrenderer.func_78374_a(-1.0, -1.0, 1.0, (double)(0.0f + f4), (double)(0.0f + f4));
                worldrenderer.func_78374_a(1.0, -1.0, 1.0, (double)(1.0f - f4), (double)(0.0f + f4));
                worldrenderer.func_78374_a(1.0, 1.0, 1.0, (double)(1.0f - f4), (double)(1.0f - f4));
                worldrenderer.func_78374_a(-1.0, 1.0, 1.0, (double)(0.0f + f4), (double)(1.0f - f4));
                worldrenderer.func_78381_a();
                GlStateManager.popMatrix();
            }
            GlStateManager.popMatrix();
            GlStateManager.colorMask(true, true, true, false);
        }
        worldrenderer.func_78373_b(0.0, 0.0, 0.0);
        GlStateManager.colorMask(true, true, true, true);
        GlStateManager.matrixMode(5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        GlStateManager.depthMask(true);
        GlStateManager.enableCull();
        GlStateManager.enableDepth();
    }

    public void func_73876_c() {
        for (Image i : this.guiConfig.customImages) {
            if (!i.ichBinEineSlideshow) continue;
            i.slideShow.update();
        }
        if (this.guiConfig.panorama != null) {
            if (this.guiConfig.panorama.synced) {
                GuiCustom mainMenu = CustomMainMenu.INSTANCE.config.getGUI("mainmenu");
                this.panoramaTimer = mainMenu.panoramaTimer;
                mainMenu.panoramaTimer = this.panoramaTimer = mainMenu.guiConfig.panorama.animate ? (this.panoramaTimer = this.panoramaTimer + mainMenu.guiConfig.panorama.animationSpeed) : mainMenu.guiConfig.panorama.position;
            } else {
                int n = this.panoramaTimer = this.guiConfig.panorama.animate ? (this.panoramaTimer = this.panoramaTimer + this.guiConfig.panorama.animationSpeed) : this.guiConfig.panorama.position;
            }
        }
        if (this.guiConfig.background != null && this.guiConfig.background.ichBinEineSlideshow) {
            this.guiConfig.background.slideShow.update();
        }
        if (Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)19)) {
            CustomMainMenu.INSTANCE.reload();
            if (Keyboard.isKeyDown((int)42)) {
                this.field_146297_k.func_110436_a();
            }
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMainMenu());
        }
    }

    private void rotateAndBlurSkybox(float p_73968_1_) {
        this.field_146297_k.func_110434_K().func_110577_a(this.field_110351_G);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.colorMask(true, true, true, false);
        Tessellator worldrenderer = Tessellator.field_78398_a;
        worldrenderer.func_78382_b();
        GlStateManager.disableAlpha();
        int b0 = 3;
        if (this.guiConfig.panorama.blur) {
            for (int i = 0; i < b0; ++i) {
                worldrenderer.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f / (float)(i + 1));
                int j = this.field_146294_l;
                int k = this.field_146295_m;
                float f1 = (float)(i - b0 / 2) / 256.0f;
                worldrenderer.func_78374_a((double)j, (double)k, (double)this.field_73735_i, (double)(0.0f + f1), 1.0);
                worldrenderer.func_78374_a((double)j, 0.0, (double)this.field_73735_i, (double)(1.0f + f1), 1.0);
                worldrenderer.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(1.0f + f1), 0.0);
                worldrenderer.func_78374_a(0.0, (double)k, (double)this.field_73735_i, (double)(0.0f + f1), 0.0);
            }
        }
        worldrenderer.func_78381_a();
        GlStateManager.enableAlpha();
        GlStateManager.colorMask(true, true, true, true);
    }

    private int modX(int posX, Alignment alignment) {
        return (int)((float)posX + (float)this.field_146294_l * alignment.factorX);
    }

    private int modY(int posY, Alignment alignment) {
        return (int)((float)posY + (float)this.field_146295_m * alignment.factorY);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiCustomWrappedButton) {
            GuiCustomWrappedButton wrapped = (GuiCustomWrappedButton)button;
            if (this.guiConfig.name.equals("mainmenu")) {
                if (wrapped.wrappedButton == null) return;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)new GuiFakeMain(), wrapped.wrappedButton, new ArrayList());
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                event.button.func_146113_a(this.field_146297_k.func_147118_V());
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) return;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)new GuiFakeMain(), wrapped.wrappedButton, new ArrayList()));
                return;
            }
        }
        if (button.field_146127_k < 6000) return;
        if (!(button instanceof GuiCustomButton)) return;
        GuiCustomButton custom = (GuiCustomButton)button;
        if (custom.b.action == null) return;
        custom.b.action.perform(custom.b, this);
    }
}

