/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.overlay;

import cofh.api.energy.IEnergyContainerItem;
import com.caedis.duradisplay.config.ConfigDurabilityLike;
import com.caedis.duradisplay.config.DuraDisplayConfig;
import com.caedis.duradisplay.overlay.OverlayDurabilityLike;
import com.caedis.duradisplay.utils.ColorType;
import com.caedis.duradisplay.utils.DurabilityFormatter;
import com.caedis.duradisplay.utils.DurabilityLikeInfo;
import com.caedis.duradisplay.utils.ModSelfDrawnBar;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OverlayCharge
extends OverlayDurabilityLike {
    public OverlayCharge() {
        super(new ConfigDurabilityLike(true, OverlayDurabilityLike.Style.Text, DurabilityFormatter.Format.percent, 8, true, true, 0xFF55FF, ColorType.Smooth, new double[]{30.0, 70.0}, new int[]{16759210, 12441343, 0x55FFFF}, true, 2, true){

            @Override
            public void postLoadConfig() {
                if (this.enabled && DuraDisplayConfig.Enable) {
                    ModSelfDrawnBar.changeChargebar(false);
                } else {
                    ModSelfDrawnBar.restoreChargebar();
                }
                this.configCategory.setComment("Charge is the module that shows charge(Electricity/Power) of items\nGT EU, IC2 EU, RF included\n");
            }

            @Override
            @NotNull
            public String category() {
                return "charge";
            }
        });
        this.addHandler("ic2.api.item.IElectricItem", OverlayCharge::handleIElectricItem);
        this.addHandler("tconstruct.library.tools.ToolCore", OverlayCharge::handleToolCore);
        this.addHandler("cofh.api.energy.IEnergyContainerItem", OverlayCharge::handleEnergyContainer);
    }

    @Override
    @NotNull
    ConfigDurabilityLike config() {
        return this.config;
    }

    public static DurabilityLikeInfo handleIElectricItem(@NotNull ItemStack stack) {
        IElectricItem bei = (IElectricItem)stack.func_77973_b();
        assert (bei != null);
        return new DurabilityLikeInfo(ElectricItem.manager.getCharge(stack), bei.getMaxCharge(stack));
    }

    public static DurabilityLikeInfo handleEnergyContainer(@NotNull ItemStack stack) {
        IEnergyContainerItem eci = (IEnergyContainerItem)stack.func_77973_b();
        assert (eci != null);
        return new DurabilityLikeInfo(eci.getEnergyStored(stack), eci.getMaxEnergyStored(stack));
    }

    public static DurabilityLikeInfo handleToolCore(@NotNull ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Energy")) {
            return null;
        }
        return OverlayCharge.handleEnergyContainer(stack);
    }
}

