/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.google.common.reflect.TypeToken;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class MessageTileEntity<T extends TileEntity>
implements IMessage {
    protected int x;
    protected int y;
    protected int z;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(T tile) {
        this.x = ((TileEntity)tile).field_145851_c;
        this.y = ((TileEntity)tile).field_145848_d;
        this.z = ((TileEntity)tile).field_145849_e;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    protected T getTileEntity(World worldObj) {
        if (worldObj == null) {
            return null;
        }
        TileEntity te = worldObj.func_147438_o(this.x, this.y, this.z);
        if (te == null) {
            return null;
        }
        TypeToken teType = TypeToken.of(this.getClass()).resolveType(MessageTileEntity.class.getTypeParameters()[0]);
        if (teType.isAssignableFrom(te.getClass())) {
            return (T)te;
        }
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }
}

