/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.block;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import ganymedes01.etfuturum.blocks.IDoubleLayerBlock;
import ganymedes01.etfuturum.blocks.IEmissiveLayerBlock;
import ganymedes01.etfuturum.client.renderer.block.BlockModelBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

@ThreadSafeISBRH(perThread=false)
public class BlockDoubleLayerRenderer
extends BlockModelBase {
    public BlockDoubleLayerRenderer(int modelID) {
        super(modelID);
    }

    @Override
    protected void renderInventoryModel(Block block, int meta, int modelId, RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(block instanceof IDoubleLayerBlock)) {
            throw new IllegalArgumentException("Block using double layer renderer must implement IDoubleLayerBlock!");
        }
        if (((IDoubleLayerBlock)block).isMetaNormalBlock(meta)) {
            super.renderInventoryModel(block, meta, modelId, renderer, minX, minY, minZ, maxX, maxY, maxZ);
            return;
        }
        boolean secondLayerAbove = ((IEmissiveLayerBlock)block).isSecondLayerAbove(meta);
        this.renderStandardInventoryCubeOrSecondLayer(block, meta, modelId, renderer, !secondLayerAbove, minX, minY, minZ, maxX, maxY, maxZ);
        this.renderStandardInventoryCubeOrSecondLayer(block, meta, modelId, renderer, secondLayerAbove, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void renderStandardInventoryCubeOrSecondLayer(Block block, int meta, int modelId, RenderBlocks renderer, boolean secondLayer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 0, meta, secondLayer));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 1, meta, secondLayer));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 2, meta, secondLayer));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 3, meta, secondLayer));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 4, meta, secondLayer));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 5, meta, secondLayer));
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (((IEmissiveLayerBlock)block).isMetaNormalBlock(world.func_72805_g(x, y, z))) {
            return super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        }
        boolean emissiveLayerAbove = ((IEmissiveLayerBlock)block).isSecondLayerAbove(world.func_72805_g(x, y, z));
        return this.renderStandardWorldCubeWithEmissiveness(world, x, y, z, block, modelId, renderer, !emissiveLayerAbove, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C()) && this.renderStandardWorldCubeWithEmissiveness(world, x, y, z, block, modelId, renderer, emissiveLayerAbove, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
    }

    protected boolean renderStandardWorldCubeWithEmissiveness(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, boolean secondLayer, double minX, double minY, double minZ, double maxF, double maxY, double maxZ) {
        if (!(block instanceof IEmissiveLayerBlock)) {
            throw new IllegalArgumentException("Block using emissive layer renderer must implement IEmissiveLayerBlock!");
        }
        if (!secondLayer) {
            return super.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, minX, minY, minZ, maxF, maxY, maxZ);
        }
        renderer.func_147782_a(minX, minY, minZ, maxF, maxY, maxZ);
        int meta = world.func_72805_g(x, y, z);
        this.renderFaceYNeg(renderer, block, x, y, z, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 0, meta, true));
        this.renderFaceYPos(renderer, block, x, y, z, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 1, meta, true));
        this.renderFaceZNeg(renderer, block, x, y, z, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 2, meta, true));
        this.renderFaceZPos(renderer, block, x, y, z, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 3, meta, true));
        this.renderFaceXNeg(renderer, block, x, y, z, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 4, meta, true));
        this.renderFaceXPos(renderer, block, x, y, z, 0.0, 0.0, 0.0, this.getIconOrSecondLayerIcon(block, renderer, 5, meta, true));
        return true;
    }

    private IIcon getIconOrSecondLayerIcon(Block block, RenderBlocks renderer, int side, int meta, boolean secondLayer) {
        return secondLayer ? ((IEmissiveLayerBlock)block).getSecondLayerIcon(side, meta) : renderer.func_147787_a(block, side, meta);
    }
}

