/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.compat.CompatBaublesExpanded;
import ganymedes01.etfuturum.compat.CompatCraftTweaker;
import ganymedes01.etfuturum.compat.CompatThaumcraft;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.compat.nei.IMCSenderGTNH;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.core.utils.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import me.eigenraven.lwjgl3ify.api.ConfigUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.gen.feature.WorldGenerator;

public class CompatMisc {
    private static final ClassLoader CLASSLOADER = EtFuturum.class.getClassLoader();

    public static void doLwjgl3ifyCompat() {
        try {
            ArrayList<String> extensibleEnums = new ArrayList<String>();
            if (ConfigMixins.enableSpectatorMode) {
                extensibleEnums.add("net.minecraft.world.WorldSettings$GameType");
            }
            extensibleEnums.add("ganymedes01.etfuturum.tileentities.TileEntityBanner$EnumBannerPattern");
            ConfigUtils utils = new ConfigUtils(null);
            Logger.trace("Found lwjgl3ify, registering the following extensible enum classes: " + extensibleEnums);
            for (String e : extensibleEnums) {
                utils.addExtensibleEnum(e);
            }
        }
        catch (Throwable t) {
            if (t instanceof NoClassDefFoundError) {
                Logger.trace("Failed to apply lwjgl3ify compat: " + t + ". This is not an error unless lwjgl3ify is present.");
            }
            Logger.warn("Failed to apply lwjgl3ify compat");
            t.printStackTrace();
        }
    }

    public static void runModHooksPreInit() {
        if (ConfigModCompat.elytraBaublesExpandedCompat > 0 && ModsList.BAUBLES_EXPANDED.isLoaded()) {
            CompatBaublesExpanded.preInit();
        }
    }

    public static void runModHooksInit() {
        IMCSenderGTNH.IMCSender();
        if (ModsList.MULTIPART.isLoaded() && ModsList.MULTIPART.isVersionNewerOrEqual("1.4.2")) {
            try {
                Class button = ReflectionHelper.getClass((ClassLoader)CLASSLOADER, (String[])new String[]{"codechicken.multipart.minecraft.ButtonPart"});
                Field metaSideMapField = ReflectionHelper.findField((Class)button, (String[])new String[]{"metaSideMap"});
                metaSideMapField.setAccessible(true);
                int[] metaSideMap = (int[])metaSideMapField.get(null);
                metaSideMap[0] = 1;
                metaSideMap[5] = 0;
                metaSideMapField.set(null, metaSideMap);
                Field sideMetaMapField = ReflectionHelper.findField((Class)button, (String[])new String[]{"sideMetaMap"});
                sideMetaMapField.setAccessible(true);
                int[] sideMetaMap = (int[])sideMetaMapField.get(null);
                sideMetaMap[0] = 5;
                sideMetaMap[1] = 0;
                sideMetaMapField.set(null, sideMetaMap);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void runModHooksPostInit() {
        Item stoneTile;
        if (ModsList.THAUMCRAFT.isLoaded()) {
            CompatThaumcraft.doAspects();
        }
        if (ModsList.MINETWEAKER_3.isLoaded()) {
            CompatCraftTweaker.onPostInit();
        }
        if (ConfigBlocksItems.enableSmoothStone && ModsList.BLUEPOWER.isLoaded() && (stoneTile = GameRegistry.findItem((String)"bluepower", (String)"stone_tile")) != null) {
            Item stoneItem = Item.func_150898_a((Block)Blocks.field_150348_b);
            FurnaceRecipes.func_77602_a().func_77599_b().entrySet().removeIf(recipe -> recipe.getValue() != null && ((ItemStack)recipe.getValue()).func_77973_b() == stoneTile && recipe.getKey() != null && ((ItemStack)recipe.getKey()).func_77973_b() == stoneItem);
        }
    }

    public static void runModHooksLoadComplete() {
        if (ModBlocks.SPONGE.isEnabled() && ModsList.BIOMES_O_PLENTY.isLoaded()) {
            try {
                Field featureMapField = Class.forName("biomesoplenty.common.world.generation.WorldGenFieldAssociation").getDeclaredField("featureMap");
                Map featureMap = (Map)featureMapField.get(null);
                Object feature = featureMap.get("generateSponge");
                Field worldGeneratorField = feature.getClass().getDeclaredField("worldGenerator");
                worldGeneratorField.setAccessible(true);
                WorldGenerator worldGenerator = (WorldGenerator)worldGeneratorField.get(feature);
                Class<?> splotches = Class.forName("biomesoplenty.common.world.features.WorldGenSplotches");
                Field splotchBlockField = splotches.getDeclaredField("splotchBlock");
                Field splotchBlockMetaField = splotches.getDeclaredField("splotchBlockMeta");
                splotchBlockField.setAccessible(true);
                splotchBlockMetaField.setAccessible(true);
                splotchBlockField.set(worldGenerator, ModBlocks.SPONGE.get());
                splotchBlockMetaField.set(worldGenerator, 1);
            }
            catch (Exception featureMapField) {
                // empty catch block
            }
        }
        if (ConfigSounds.newBlockSounds) {
            Block saltOre;
            if (ModsList.NETHERITEPLUS.isLoaded()) {
                Blocks.field_150385_bj.func_149672_a(ModSounds.soundNetherBricks);
                Blocks.field_150386_bk.func_149672_a(ModSounds.soundNetherBricks);
                Blocks.field_150387_bl.func_149672_a(ModSounds.soundNetherBricks);
            }
            if (ModsList.NATURA.isLoaded()) {
                Block block = GameRegistry.findBlock((String)"Natura", (String)"NetherFurnace");
                if (block != null) {
                    block.func_149672_a(ModSounds.soundNetherrack);
                }
                if ((block = GameRegistry.findBlock((String)"Natura", (String)"NetherLever")) != null) {
                    block.func_149672_a(ModSounds.soundNetherrack);
                }
                if ((block = GameRegistry.findBlock((String)"Natura", (String)"NetherPressurePlate")) != null) {
                    block.func_149672_a(ModSounds.soundNetherrack);
                }
                if ((block = GameRegistry.findBlock((String)"Natura", (String)"NetherButton")) != null) {
                    block.func_149672_a(ModSounds.soundNetherrack);
                }
            }
            if ((saltOre = GameRegistry.findBlock((String)"SaltMod", (String)"saltDeepslateOre")) != null) {
                saltOre.func_149672_a(ModSounds.soundDeepslate);
            }
        }
    }
}

