/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ganymedes01.etfuturum.client.gui.inventory.GuiSmoker;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import ganymedes01.etfuturum.recipes.SmokerRecipes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.StatCollector;

public class SmokerRecipeHandler
extends FurnaceRecipeHandler {
    private final ArrayList<TemplateRecipeHandler.CachedRecipe> basecache = new ArrayList();
    private final ArrayList<TemplateRecipeHandler.CachedRecipe> recipecache = new ArrayList();
    private final ArrayList<TemplateRecipeHandler.CachedRecipe> usagecache = new ArrayList();

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), this.getOverlayIdentifier(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            if (this.basecache.isEmpty()) {
                Map furnaceSmeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
                ItemStackMap<ItemStack> recipes = new ItemStackMap<ItemStack>();
                for (Map.Entry entry : furnaceSmeltingList.entrySet()) {
                    if (!SmokerRecipes.smelting().canAdd((ItemStack)entry.getKey(), (ItemStack)entry.getValue())) continue;
                    recipes.put((ItemStack)entry.getKey(), (ItemStack)entry.getValue());
                }
                recipes.putAll(SmokerRecipes.smelting().smeltingList);
                recipes.entrySet().removeIf(stack -> SmokerRecipes.smelting().smeltingBlacklist.contains((ItemStack)stack.getKey()));
                for (Map.Entry<Object, Object> entry : recipes.entrySet()) {
                    this.arecipes.add(new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, (ItemStack)entry.getKey(), (ItemStack)entry.getValue()));
                    this.basecache.addAll(this.arecipes);
                }
            } else {
                this.arecipes.addAll(this.basecache);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (this.recipecache.isEmpty()) {
            Map furnaceSmeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
            ItemStackMap<ItemStack> recipes = new ItemStackMap<ItemStack>();
            for (Map.Entry entry : furnaceSmeltingList.entrySet()) {
                if (!SmokerRecipes.smelting().canAdd((ItemStack)entry.getKey(), (ItemStack)entry.getValue())) continue;
                recipes.put((ItemStack)entry.getKey(), (ItemStack)entry.getValue());
            }
            recipes.putAll(SmokerRecipes.smelting().smeltingList);
            recipes.entrySet().removeIf(stack -> SmokerRecipes.smelting().smeltingBlacklist.contains((ItemStack)stack.getKey()));
            for (Map.Entry<Object, Object> entry : recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)entry.getValue()), (ItemStack)result)) continue;
                this.arecipes.add(new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, (ItemStack)entry.getKey(), (ItemStack)entry.getValue()));
                this.recipecache.addAll(this.arecipes);
            }
        } else {
            this.arecipes.addAll(this.recipecache);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (this.usagecache.isEmpty()) {
            Map furnaceSmeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
            ItemStackMap<ItemStack> recipes = new ItemStackMap<ItemStack>();
            for (Map.Entry entry : furnaceSmeltingList.entrySet()) {
                if (!SmokerRecipes.smelting().canAdd((ItemStack)entry.getKey(), (ItemStack)entry.getValue())) continue;
                recipes.put((ItemStack)entry.getKey(), (ItemStack)entry.getValue());
            }
            recipes.putAll(SmokerRecipes.smelting().smeltingList);
            recipes.entrySet().removeIf(stack -> SmokerRecipes.smelting().smeltingBlacklist.contains((ItemStack)stack.getKey()));
            for (Map.Entry<Object, Object> entry : recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)entry.getKey()), (ItemStack)ingredient)) continue;
                FurnaceRecipeHandler.SmeltingPair arecipe = new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, (ItemStack)entry.getKey(), (ItemStack)entry.getValue());
                this.arecipes.add(arecipe);
            }
            this.usagecache.addAll(this.arecipes);
        } else {
            this.arecipes.addAll(this.usagecache);
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"efr.nei.smoker");
    }

    public String getOverlayIdentifier() {
        return "etfuturum.smoker";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSmoker.class;
    }

    public void clearCache() {
        this.basecache.clear();
        this.recipecache.clear();
        this.usagecache.clear();
    }
}

