/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.storage;

import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public final class EtFuturumPlayer
implements IExtendedEntityProperties {
    private static final String PROPERTIES_NAME = "etfuturum";
    private static final String TAG_ENCHANTMENT_SEED = "EnchantmentSeed";
    private int enchantmentSeed = 0;

    private EtFuturumPlayer() {
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        if (ConfigBlocksItems.enableEnchantingTable) {
            tag.func_74768_a(TAG_ENCHANTMENT_SEED, this.enchantmentSeed);
        }
        if (!tag.func_82582_d()) {
            compound.func_74782_a(PROPERTIES_NAME, (NBTBase)tag);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (!compound.func_150297_b(PROPERTIES_NAME, 10)) {
            return;
        }
        NBTTagCompound tag = compound.func_74775_l(PROPERTIES_NAME);
        if (tag.func_150297_b(TAG_ENCHANTMENT_SEED, 3)) {
            this.enchantmentSeed = tag.func_74762_e(TAG_ENCHANTMENT_SEED);
        }
    }

    public void init(Entity entity, World world) {
        this.enchantmentSeed = world.field_73012_v.nextInt();
    }

    public static EtFuturumPlayer get(EntityPlayer player) {
        EtFuturumPlayer data = (EtFuturumPlayer)player.getExtendedProperties(PROPERTIES_NAME);
        return data == null ? EtFuturumPlayer.register(player) : data;
    }

    public static EtFuturumPlayer register(EntityPlayer player) {
        EtFuturumPlayer data = new EtFuturumPlayer();
        player.registerExtendedProperties(PROPERTIES_NAME, (IExtendedEntityProperties)data);
        return data;
    }

    public static void clone(EntityPlayer original, EntityPlayer current) {
        if (original != null && current != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            EtFuturumPlayer.get(original).saveNBTData(nbt);
            EtFuturumPlayer.get(current).loadNBTData(nbt);
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void setEnchantmentSeed(int enchantmentSeed) {
        this.enchantmentSeed = enchantmentSeed;
    }
}

