/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.tileentities;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityNewBeacon
extends TileEntityBeacon {
    private final List<BeamSegment> segments = Lists.newArrayList();

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)Double.POSITIVE_INFINITY, (double)(this.field_145849_e + 1));
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.updateSegments();
        }
    }

    private void updateSegments() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        this.segments.clear();
        BeamSegment beamsegment = new BeamSegment(EntitySheep.field_70898_d[0]);
        this.segments.add(beamsegment);
        boolean flag = true;
        for (int i = y + 1; i < this.field_145850_b.func_72940_L(); ++i) {
            Block iblockstate = this.field_145850_b.func_147439_a(x, i, z);
            float[] colors = null;
            Item itemBlock = Item.func_150898_a((Block)iblockstate);
            if (itemBlock != null) {
                block1: for (String tag : EtFuturum.getOreStrings(new ItemStack(itemBlock, 1, this.field_145850_b.func_72805_g(x, i, z)))) {
                    if (colors != null) break;
                    String tagLower = tag.toLowerCase();
                    for (int j = 0; j < 16; ++j) {
                        String oreDye = ModRecipes.ore_dyes[15 - j].substring(3).toLowerCase();
                        if (!tagLower.contains("glass") || !tagLower.contains(oreDye) || !oreDye.contains("light") && tagLower.contains("light")) continue;
                        colors = EntitySheep.field_70898_d[j];
                        continue block1;
                    }
                }
            }
            if (colors == null) {
                if (iblockstate.func_149717_k() >= 15) {
                    this.segments.clear();
                    break;
                }
                beamsegment.incrementHeight();
                continue;
            }
            if (!flag) {
                colors = new float[]{(beamsegment.getColor()[0] + colors[0]) / 2.0f, (beamsegment.getColor()[1] + colors[1]) / 2.0f, (beamsegment.getColor()[2] + colors[2]) / 2.0f};
            }
            if (Arrays.equals(colors, beamsegment.getColor())) {
                beamsegment.incrementHeight();
            } else {
                beamsegment = new BeamSegment(colors);
                this.segments.add(beamsegment);
            }
            flag = false;
        }
    }

    public List<BeamSegment> getSegments() {
        return this.segments;
    }

    public static class BeamSegment {
        private final float[] colours;
        private int height;

        public BeamSegment(float[] colours) {
            this.colours = colours;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        public float[] getColor() {
            return this.colours;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

