/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.decorate;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenCherryTrees
extends WorldGenAbstractTree {
    private final int branchCountMin;
    private final int branchCountMax;
    private final int branchHorizontalLengthMin;
    private final int branchHorizontalLengthMax;
    private final int branchStartOffsetFromTopMin;
    private final int branchStartOffsetFromTopMax;
    private final int branchEndOffsetFromTopMin;
    private final int branchEndOffsetFromTopMax;
    private final boolean doNotify;
    private static final float CORNER_HOLE_CHANCE = 0.25f;
    private static final float HANGING_LEAVES_CHANCE = 0.16666667f;
    private static final float HANGING_LEAVES_EXTENSION_CHANCE = 0.33333334f;
    private static final int FOLIAGE_HEIGHT = 5;
    private static final int FOLIAGE_RADIUS = 4;
    private static final float WIDE_BOTTOM_LAYER_HOLE_CHANCE = 0.25f;

    public WorldGenCherryTrees(boolean p_i2008_1_) {
        super(p_i2008_1_);
        this.branchCountMin = 1;
        this.branchCountMax = 3;
        this.branchHorizontalLengthMin = 2;
        this.branchHorizontalLengthMax = 4;
        this.branchStartOffsetFromTopMin = -4;
        this.branchStartOffsetFromTopMax = -3;
        this.branchEndOffsetFromTopMin = -1;
        this.branchEndOffsetFromTopMax = 0;
        this.doNotify = p_i2008_1_;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        if (this.checkSpace(world, rand, x, y, z)) {
            boolean flag1;
            int branchCount;
            int height = 7;
            world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
            int firstBranchOffsetFromTop = Math.max(0, height - 1 + MathHelper.func_76136_a((Random)rand, (int)this.branchStartOffsetFromTopMin, (int)this.branchStartOffsetFromTopMax));
            int secondBranchOffsetFromTop = Math.max(0, height - 1 + MathHelper.func_76136_a((Random)rand, (int)this.branchStartOffsetFromTopMin, (int)this.branchStartOffsetFromTopMax));
            if (secondBranchOffsetFromTop >= firstBranchOffsetFromTop) {
                ++secondBranchOffsetFromTop;
            }
            boolean flag = (branchCount = MathHelper.func_76136_a((Random)rand, (int)this.branchCountMin, (int)this.branchCountMax)) == 3;
            boolean bl = flag1 = branchCount >= 2;
            int treeHeight = flag ? height : (flag1 ? Math.max(firstBranchOffsetFromTop, secondBranchOffsetFromTop) + 1 : firstBranchOffsetFromTop + 1);
            for (int i1 = 0; i1 < treeHeight; ++i1) {
                world.func_147449_b(x, y + i1, z, ModBlocks.CHERRY_LOG.get());
            }
            if (flag) {
                this.generateLeaves(world, rand, x, y + treeHeight, z);
            }
            ForgeDirection direction = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(4) + 2];
            this.generateBranch(world, x, y, z, rand, height, direction, firstBranchOffsetFromTop, firstBranchOffsetFromTop < treeHeight - 1);
            if (flag1) {
                this.generateBranch(world, x, y, z, rand, height, direction.getOpposite(), secondBranchOffsetFromTop, secondBranchOffsetFromTop < treeHeight - 1);
            }
            return true;
        }
        return false;
    }

    private void generateBranch(World world, int x, int y, int z, Random rand, int height, ForgeDirection dir, int branchStartOffset, boolean lower) {
        ForgeDirection branchDir;
        int mutableX = x;
        int mutableY = y + branchStartOffset;
        int mutableZ = z;
        int i = height - 1 + MathHelper.func_76136_a((Random)rand, (int)this.branchEndOffsetFromTopMin, (int)this.branchEndOffsetFromTopMax);
        boolean flag = lower || i < branchStartOffset;
        int j = MathHelper.func_76136_a((Random)rand, (int)this.branchHorizontalLengthMin, (int)this.branchHorizontalLengthMax) + (flag ? 1 : 0);
        int k = flag ? 2 : 1;
        int branchEndX = mutableX + dir.offsetX * j;
        int branchEndY = mutableY + i;
        int branchEndZ = mutableZ + dir.offsetZ * j;
        for (int l = 0; l < k; ++l) {
            this.func_150516_a(world, mutableX += dir.offsetX, mutableY, mutableZ += dir.offsetZ, ModBlocks.CHERRY_LOG.get(), dir.offsetX != 0 ? 4 : (dir.offsetZ != 0 ? 8 : 0));
        }
        ForgeDirection forgeDirection = branchDir = branchEndY > mutableY ? ForgeDirection.UP : ForgeDirection.DOWN;
        while (true) {
            int i1;
            if ((i1 = Utils.distManhattan(branchEndX, branchEndY, branchEndZ, mutableX, mutableY, mutableZ)) == 0) {
                this.generateLeaves(world, rand, branchEndX, branchEndY + 1, branchEndZ);
                return;
            }
            float f = (float)Math.abs(branchEndY - mutableY) / (float)i1;
            boolean flag1 = rand.nextFloat() < f;
            ForgeDirection logDir = flag1 ? branchDir : dir;
            this.func_150516_a(world, mutableX += logDir.offsetX, mutableY += logDir.offsetY, mutableZ += logDir.offsetZ, ModBlocks.CHERRY_LOG.get(), logDir.offsetX != 0 ? 4 : (logDir.offsetZ != 0 ? 8 : 0));
        }
    }

    protected void generateLeaves(World world, Random random, int x, int y, int z) {
        int i = 3;
        this.generateSquare(world, random, x, y, z, i - 2, 2);
        this.generateSquare(world, random, x, y, z, i - 1, 1);
        for (int j = 0; j == 0; --j) {
            this.generateSquare(world, random, x, y, z, i, j);
        }
        this.generateSquareWithHangingLeaves(world, random, x, y, z, i, -1);
        this.generateSquareWithHangingLeaves(world, random, x, y, z, i - 1, -2);
    }

    protected void generateSquare(World world, Random random, int x, int y, int z, int radius, int height) {
        for (int j = -radius; j <= radius; ++j) {
            for (int k = -radius; k <= radius; ++k) {
                if (this.isPositionInvalid(random, j, height, k, radius)) continue;
                this.placeLeaves(world, x + j, y + height, z + k);
            }
        }
    }

    private void generateSquareWithHangingLeaves(World world, Random random, int x, int y, int z, int radius, int height) {
        this.generateSquare(world, random, x, y, z, radius, height);
        int my = y - radius - 1;
        for (int mx = x - radius; mx <= x + radius; ++mx) {
            for (int mz = z - radius; mz <= z + radius; ++mz) {
                int offset;
                if (!(random.nextFloat() < 0.16666667f)) continue;
                for (offset = 0; offset <= 3; ++offset) {
                    if (offset == 3) {
                        return;
                    }
                    if (world.func_147439_a(mx, my + offset, mz).isReplaceable((IBlockAccess)world, mx, my + offset, mz) && world.func_147439_a(mx, my + offset + 1, mz) == ModBlocks.LEAVES.get() && world.func_72805_g(mx, my + offset + 1, mz) == 1) break;
                }
                this.placeLeaves(world, mx, my + offset, mz);
                if (!(random.nextFloat() < 0.33333334f)) continue;
                this.placeLeaves(world, mx, my + offset - 1, mz);
            }
        }
    }

    protected boolean isPositionInvalid(Random random, int dx, int y, int dz, int radius) {
        return this.isInvalidForLeaves(random, Math.abs(dx), y, Math.abs(dz), radius);
    }

    protected boolean isInvalidForLeaves(Random random, int dx, int y, int dz, int radius) {
        boolean bl2;
        if (y == -1 && (dx == radius || dz == radius) && random.nextFloat() < 0.25f) {
            return true;
        }
        boolean bl = dx == radius && dz == radius;
        boolean bl3 = bl2 = radius > 2;
        if (bl2) {
            return bl || dx + dz > radius * 2 - 2 && random.nextFloat() < 0.25f;
        }
        return bl && random.nextFloat() < 0.25f;
    }

    protected boolean checkSpace(World world, Random random, int x, int y, int z) {
        if (this.doNotify) {
            for (int my = y + 1; my <= y + 6; ++my) {
                for (int mx = x - 1; mx <= x + 1; ++mx) {
                    for (int mz = z - 1; mz <= z + 1; ++mz) {
                        if (world.func_147439_a(mx, my, mz).isReplaceable((IBlockAccess)world, mx, my, mz)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void placeLeaves(World world, int x, int y, int z) {
        if (!(world.func_147439_a(x, y, z) instanceof BlockLog)) {
            this.func_150516_a(world, x, y, z, ModBlocks.LEAVES.get(), 1);
        }
    }

    protected void func_150516_a(World world, int x, int y, int z, Block p_150516_5_, int p_150516_6_) {
        if (world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) || this.isReplaceable(world, x, y, z)) {
            super.func_150516_a(world, x, y, z, p_150516_5_, p_150516_6_);
        }
    }
}

