/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.enderconstructor;

import cofh.api.energy.EnergyStorage;
import com.rwtema.extrautils.tileentity.enderconstructor.EnderConstructorRecipesHandler;
import com.rwtema.extrautils.tileentity.enderconstructor.TileEnderConstructor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryKraft
implements ISidedInventory {
    public CraftMatrix matrix = new CraftMatrix();
    public CraftResult result;
    EnergyStorage energy;
    TileEnderConstructor tile;
    ItemStack bufferItem;

    public InventoryKraft(TileEnderConstructor tile) {
        this.energy = tile.energy;
        this.tile = tile;
        this.result = new CraftResult(tile, this.matrix);
    }

    public void readFromNBT(NBTTagCompound tags) {
        CraftResult.crafting = true;
        for (int i = 0; i < 9; ++i) {
            if (tags.func_74764_b("items_" + i)) {
                this.matrix.inv.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("items_" + i)));
                continue;
            }
            this.matrix.inv.func_70299_a(i, null);
        }
        CraftResult.crafting = false;
    }

    public void writeToNBT(NBTTagCompound tags) {
        for (int i = 0; i < 9; ++i) {
            if (this.matrix.inv.func_70301_a(i) == null) continue;
            NBTTagCompound t = new NBTTagCompound();
            this.matrix.inv.func_70301_a(i).func_77955_b(t);
            tags.func_74782_a("items_" + i, (NBTBase)t);
        }
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int i) {
        if (i == 9) {
            return this.result.func_70301_a(0);
        }
        return this.matrix.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i == 9) {
            ItemStack item;
            if (this.tile.func_145832_p() == 4 && (item = this.result.func_70298_a(0, j)) != null) {
                if (!this.tile.func_145831_w().field_72995_K) {
                    this.energy.setEnergyStored(0);
                    this.tile.func_145831_w().func_72921_c(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 0, 2);
                } else {
                    this.tile.func_145831_w().func_72921_c(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 0, 0);
                }
                return item;
            }
            return null;
        }
        return this.matrix.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        if (i == 9) {
            return this.result.func_70304_b(0);
        }
        return this.matrix.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i != 9) {
            this.matrix.func_70299_a(i, itemstack);
        }
    }

    public String func_145825_b() {
        return "Ender Crafting";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.matrix.func_70296_d();
        this.result.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i != 9;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i < 9;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 9 && this.isEnabled();
    }

    public boolean isEnabled() {
        return this.tile.energy.getEnergyStored() == this.tile.energy.getMaxEnergyStored();
    }

    public static class CraftResult
    extends InventoryBasic {
        public static boolean crafting = false;
        public CraftMatrix matrix;
        TileEnderConstructor tile;

        public CraftResult(TileEnderConstructor tile, CraftMatrix matrix) {
            super("Craft Result", false, 1);
            this.tile = tile;
            this.matrix = matrix;
            matrix.setResult(this);
        }

        public ItemStack func_70298_a(int par1, int par2) {
            return super.func_70298_a(par1, par2);
        }

        public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
            return false;
        }

        public void markDirty(CraftMatrix craftMatrix) {
            if (crafting) {
                return;
            }
            ItemStack item = EnderConstructorRecipesHandler.findMatchingRecipe(craftMatrix, this.tile.func_145831_w());
            this.func_70299_a(0, null);
            if (item != null) {
                this.func_70299_a(0, item);
            }
        }
    }

    public static class CraftMatrix
    extends InventoryCrafting {
        InventoryBasic inv = new InventoryBasic("Craft Matrix", false, 9);
        CraftResult result;

        public CraftMatrix() {
            super(null, 3, 3);
        }

        public ItemStack func_70463_b(int par1, int par2) {
            if (par1 >= 0 && par1 < 3) {
                int k = par1 + par2 * 3;
                return this.inv.func_70301_a(k);
            }
            return null;
        }

        public int func_70302_i_() {
            return this.inv.func_70302_i_();
        }

        public ItemStack func_70301_a(int i) {
            return this.inv.func_70301_a(i);
        }

        public ItemStack func_70298_a(int i, int j) {
            return this.inv.func_70298_a(i, j);
        }

        public ItemStack func_70304_b(int i) {
            return this.inv.func_70304_b(i);
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.inv.func_70299_a(i, itemstack);
        }

        public String func_145825_b() {
            return this.inv.func_145825_b();
        }

        public boolean func_145818_k_() {
            return this.inv.func_145818_k_();
        }

        public int func_70297_j_() {
            return this.inv.func_70297_j_();
        }

        public void setResult(CraftResult result) {
            this.result = result;
        }

        public void func_70296_d() {
            this.result.markDirty(this);
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public void func_70295_k_() {
            this.inv.func_70295_k_();
        }

        public void func_70305_f() {
            this.inv.func_70305_f();
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return this.inv.func_94041_b(i, itemstack);
        }
    }
}

