/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLabel
extends Gui {
    private final List<String> lines = new ArrayList<String>();
    private final FontRenderer fontRenderer;
    private final int textColor;
    public int id;
    public int x;
    public int y;
    public boolean visible = true;
    protected int width;
    protected int height;
    private boolean centered = false;

    public GuiLabel(@NonNull FontRenderer fontRenderer, int id, int x, int y, int width, int height, int textColour) {
        if (fontRenderer == null) {
            throw new NullPointerException("fontRenderer is marked non-null but is null");
        }
        this.fontRenderer = fontRenderer;
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textColor = textColour;
    }

    public void addLine(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.lines.add(I18n.func_135052_a((String)text, (Object[])new Object[0]));
    }

    public GuiLabel setCentered() {
        this.centered = true;
        return this;
    }

    public void drawLabel(@NonNull Minecraft minecraft, int mouseX, int mouseY) {
        if (minecraft == null) {
            throw new NullPointerException("minecraft is marked non-null but is null");
        }
        if (!this.visible) {
            return;
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        int topLeftY = this.y + this.height / 2 - this.lines.size() * 10 / 2;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.centered) {
                this.func_73732_a(this.fontRenderer, this.lines.get(i), this.x + this.width / 2, topLeftY + i * 10, this.textColor);
                continue;
            }
            this.func_73731_b(this.fontRenderer, this.lines.get(i), this.x, topLeftY + i * 10, this.textColor);
        }
    }
}

