/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.dependencies;

import com.falsepattern.lib.dependencies.Version;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Library {
    @NonNull
    public final String loadingModId;
    @NonNull
    public final String groupId;
    @NonNull
    public final String artifactId;
    @NonNull
    public final Version minVersion;
    @Nullable
    public final Version maxVersion;
    @NonNull
    public final Version preferredVersion;
    @Nullable
    public final String regularSuffix;
    @Nullable
    public final String devSuffix;

    public Library(@NonNull String loadingModId, @NonNull String groupId, @NonNull String artifactId, @NonNull Version minVersion, Version maxVersion, @NonNull Version preferredVersion, String regularSuffix, String devSuffix) {
        if (loadingModId == null) {
            throw new NullPointerException("loadingModId is marked non-null but is null");
        }
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId is marked non-null but is null");
        }
        if (minVersion == null) {
            throw new NullPointerException("minVersion is marked non-null but is null");
        }
        if (preferredVersion == null) {
            throw new NullPointerException("preferredVersion is marked non-null but is null");
        }
        this.loadingModId = loadingModId;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.preferredVersion = preferredVersion;
        this.regularSuffix = regularSuffix;
        this.devSuffix = devSuffix;
    }

    public static LibraryBuilder builder() {
        return new LibraryBuilder();
    }

    public static class LibraryBuilder {
        private String loadingModId;
        private String groupId;
        private String artifactId;
        private Version minVersion;
        private Version maxVersion;
        private Version preferredVersion;
        private String regularSuffix;
        private String devSuffix;

        @ApiStatus.Internal
        LibraryBuilder() {
        }

        public LibraryBuilder loadingModId(@NonNull String loadingModId) {
            if (loadingModId == null) {
                throw new NullPointerException("loadingModId is marked non-null but is null");
            }
            this.loadingModId = loadingModId;
            return this;
        }

        public LibraryBuilder groupId(@NonNull String groupId) {
            if (groupId == null) {
                throw new NullPointerException("groupId is marked non-null but is null");
            }
            this.groupId = groupId;
            return this;
        }

        public LibraryBuilder artifactId(@NonNull String artifactId) {
            if (artifactId == null) {
                throw new NullPointerException("artifactId is marked non-null but is null");
            }
            this.artifactId = artifactId;
            return this;
        }

        public LibraryBuilder minVersion(@NonNull Version minVersion) {
            if (minVersion == null) {
                throw new NullPointerException("minVersion is marked non-null but is null");
            }
            this.minVersion = minVersion;
            return this;
        }

        public LibraryBuilder maxVersion(Version maxVersion) {
            this.maxVersion = maxVersion;
            return this;
        }

        public LibraryBuilder preferredVersion(@NonNull Version preferredVersion) {
            if (preferredVersion == null) {
                throw new NullPointerException("preferredVersion is marked non-null but is null");
            }
            this.preferredVersion = preferredVersion;
            return this;
        }

        public LibraryBuilder regularSuffix(String regularSuffix) {
            this.regularSuffix = regularSuffix;
            return this;
        }

        public LibraryBuilder devSuffix(String devSuffix) {
            this.devSuffix = devSuffix;
            return this;
        }

        public Library build() {
            return new Library(this.loadingModId, this.groupId, this.artifactId, this.minVersion, this.maxVersion, this.preferredVersion, this.regularSuffix, this.devSuffix);
        }

        public String toString() {
            return "Library.LibraryBuilder(loadingModId=" + this.loadingModId + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ", preferredVersion=" + this.preferredVersion + ", regularSuffix=" + this.regularSuffix + ", devSuffix=" + this.devSuffix + ")";
        }
    }
}

