/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config;

import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.event.AllConfigSyncEvent;
import com.falsepattern.lib.config.event.ConfigSyncEvent;
import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.FalsePatternLib;
import com.falsepattern.lib.internal.impl.config.ParsedConfiguration;
import com.falsepattern.lib.internal.impl.config.net.SyncRequest;
import com.falsepattern.lib.util.FileUtil;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.minecraftforge.common.config.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationManagerImpl {
    private static final Map<Path, Configuration> configs = new HashMap<Path, Configuration>();
    private static final Map<String, Set<Class<?>>> modConfigs = new HashMap();
    private static final Map<Configuration, Set<Class<?>>> configToClassMap = new HashMap();
    private static final Map<Class<?>, ParsedConfiguration> parsedConfigMap = new HashMap();
    private static final BiMap<String, Class<?>> serializedNames = HashBiMap.create();
    private static boolean initialized = false;
    private static Path configDir;

    public static void register(Class<?> configClass) throws ConfigException {
        ConfigurationManagerImpl.init();
        if (!parsedConfigMap.containsKey(configClass)) {
            ParsedConfiguration parsedConfig = ParsedConfiguration.parseConfig(configClass);
            configToClassMap.computeIfAbsent(parsedConfig.rawConfig, ignored -> new HashSet()).add(configClass);
            parsedConfigMap.put(configClass, parsedConfig);
            serializedNames.put((Object)(parsedConfig.modid + "$" + parsedConfig.category), configClass);
            modConfigs.computeIfAbsent(parsedConfig.modid, x -> new HashSet()).add(configClass);
        }
    }

    @Nullable
    private static Path resolveConfigFile(String pathSuffix, boolean create) throws ConfigException {
        String fileName;
        Path thePath = configDir.resolve(pathSuffix);
        Path parent = thePath.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            if (!create) {
                return null;
            }
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ConfigException(String.format("Failed to create config parent directory at %s", parent), e);
            }
        }
        if (!(fileName = thePath.getFileName().toString()).contains(".")) {
            thePath = parent.resolve(fileName + ".cfg");
        }
        return thePath;
    }

    @NotNull
    static Configuration getForgeConfig(String pathSuffix, boolean create) throws ConfigException {
        Path thePath = ConfigurationManagerImpl.resolveConfigFile(pathSuffix, create);
        if (thePath == null || !create && !Files.exists(thePath, new LinkOption[0])) {
            throw new ConfigException(String.format("Could not find config file at %s", pathSuffix));
        }
        return configs.computeIfAbsent(thePath, ignored -> {
            Configuration c = new Configuration(thePath.toFile());
            c.load();
            return c;
        });
    }

    public static void load(Class<?> configClass) throws ConfigException {
        if (!parsedConfigMap.containsKey(configClass)) {
            throw new ConfigException("Class " + configClass.getName() + " is not a registered configuration!");
        }
        parsedConfigMap.get(configClass).loadFile();
    }

    public static void save(Class<?> configClass) throws ConfigException {
        if (!parsedConfigMap.containsKey(configClass)) {
            throw new ConfigException("Class " + configClass.getName() + " is not a registered configuration!");
        }
        parsedConfigMap.get(configClass).saveFile();
    }

    public static boolean validateFields(BiConsumer<Class<?>, Field> invalidFieldHandler, Class<?> configClass, boolean resetInvalid) throws ConfigException {
        if (!parsedConfigMap.containsKey(configClass)) {
            throw new ConfigException("Class " + configClass.getName() + " is not a registered configuration!");
        }
        ParsedConfiguration parsed = parsedConfigMap.get(configClass);
        return parsed.validate(invalidFieldHandler, resetInvalid);
    }

    public static void sendRequest(DataOutput output) throws IOException {
        ArrayList synced = new ArrayList();
        BiMap inv = serializedNames.inverse();
        for (Map.Entry<Class<?>, ParsedConfiguration> entry : parsedConfigMap.entrySet()) {
            if (!entry.getValue().sync) continue;
            synced.add(entry.getKey());
        }
        output.writeInt(synced.size());
        for (Class clazz : synced) {
            output.writeUTF((String)inv.get((Object)clazz));
        }
    }

    public static List<Class<?>> receiveRequest(DataInput input) throws IOException {
        ArrayList result = new ArrayList();
        int count = input.readInt();
        HashSet<String> requestedNames = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            requestedNames.add(input.readUTF());
        }
        for (String entry : serializedNames.keySet()) {
            if (!requestedNames.contains(entry)) continue;
            result.add((Class)serializedNames.get((Object)entry));
        }
        return result;
    }

    public static void sendReply(DataOutput output, List<Class<?>> requestedClasses) throws IOException {
        HashMap syncEntries = new HashMap(parsedConfigMap);
        for (Map.Entry<Class<?>, ParsedConfiguration> entry : parsedConfigMap.entrySet()) {
            if (entry.getValue().sync && requestedClasses.contains(entry.getKey())) continue;
            syncEntries.remove(entry.getKey());
        }
        output.writeInt(syncEntries.size());
        BiMap inv = serializedNames.inverse();
        for (Map.Entry<Class<?>, ParsedConfiguration> entry : syncEntries.entrySet()) {
            output.writeUTF((String)inv.get(entry.getKey()));
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream bo = new DataOutputStream(b);
            entry.getValue().transmit(bo);
            bo.close();
            byte[] bytes = b.toByteArray();
            output.writeInt(bytes.length);
            output.write(bytes);
        }
    }

    public static void receiveReply(DataInput input) throws IOException {
        if (AllConfigSyncEvent.postStart()) {
            FPLog.LOG.warn("All config synchronization was cancelled by event.");
            return;
        }
        int count = input.readInt();
        for (int i = 0; i < count; ++i) {
            String serializedName = input.readUTF();
            int dataSize = input.readInt();
            Optional<String> opt = serializedNames.keySet().stream().filter(key -> key.equals(serializedName)).findFirst();
            if (!opt.isPresent()) {
                input.skipBytes(dataSize);
                FPLog.LOG.warn("Server tried to sync config not registered on our side: " + serializedName);
                continue;
            }
            Class clazz = (Class)serializedNames.get((Object)opt.get());
            ParsedConfiguration config = parsedConfigMap.get(clazz);
            if (!config.sync) {
                input.skipBytes(dataSize);
                FPLog.LOG.warn("Server tried to sync config without @Synchronize annotation on our side: " + serializedName);
                continue;
            }
            if (ConfigSyncEvent.postStart(clazz)) {
                input.skipBytes(dataSize);
                FPLog.LOG.warn("Config synchronization was cancelled by event for: " + serializedName);
                continue;
            }
            byte[] bytes = new byte[dataSize];
            input.readFully(bytes);
            ByteArrayInputStream b = new ByteArrayInputStream(bytes);
            DataInputStream bi = new DataInputStream(b);
            try {
                config.receive(bi);
                config.validate((x, y) -> {}, true);
                ConfigSyncEvent.postEndSuccess(clazz);
            }
            catch (Throwable e) {
                ConfigSyncEvent.postEndFailure(clazz, e);
            }
            bi.close();
        }
        AllConfigSyncEvent.postEnd();
    }

    public static void loadRawConfig(Configuration rawConfig) throws ConfigException {
        rawConfig.load();
        for (Class<?> configClass : configToClassMap.get(rawConfig)) {
            ParsedConfiguration config = parsedConfigMap.get(configClass);
            try {
                config.reloadFields();
            }
            catch (IllegalAccessException e) {
                throw new ConfigException(e);
            }
        }
    }

    public static List<IConfigElement> getConfigElements(Class<?> configClass) throws ConfigException {
        if (!parsedConfigMap.containsKey(configClass)) {
            throw new ConfigException("Class " + configClass.getName() + " is not a registered configuration!");
        }
        ParsedConfiguration config = parsedConfigMap.get(configClass);
        return config.getConfigElements();
    }

    private static void init() {
        if (initialized) {
            return;
        }
        configDir = FileUtil.getMinecraftHome().toPath().resolve("config");
        initialized = true;
    }

    public static DummyConfigElement.DummyCategoryElement<?> getConfigCategoryElement(Class<?> configClass) throws ConfigException {
        if (!parsedConfigMap.containsKey(configClass)) {
            throw new ConfigException("Class " + configClass.getName() + " is not a registered configuration!");
        }
        ParsedConfiguration config = parsedConfigMap.get(configClass);
        DummyConfigElement.DummyCategoryElement entry = new DummyConfigElement.DummyCategoryElement(config.category, config.langKey, config.getConfigElements());
        entry.setRequiresWorldRestart(config.requiresWorldRestart());
        entry.setRequiresMcRestart(config.requiresMcRestart());
        return entry;
    }

    public static void sendSyncRequest() throws IOException {
        SyncRequest event = new SyncRequest();
        event.transmit();
        FalsePatternLib.NETWORK.sendToServer((IMessage)event);
    }

    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        ConfigurationManagerImpl.init();
        Set<Class<?>> configs = modConfigs.get(event.modID);
        if (configs == null) {
            return;
        }
        configs.stream().map(parsedConfigMap::get).distinct().forEach(ParsedConfiguration::configChanged);
    }

    @Generated
    private ConfigurationManagerImpl() {
    }
}

