/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping;

import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import com.falsepattern.lib.mapping.storage.Lookup;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.mapping.types.UniversalMethod;
import com.falsepattern.lib.util.ResourceUtil;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class MappingManager {
    private static Lookup<UniversalClass> internalLookup;
    private static Lookup<UniversalClass> regularLookup;
    private static boolean initialized;
    private static final Object MUTEX;
    private static final AtomicLong lastInitializedAt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = MUTEX;
        synchronized (object) {
            if (initialized) {
                lastInitializedAt.set(System.currentTimeMillis());
                return;
            }
            initialized = true;
            CleanupThread cleanupThread = new CleanupThread();
            FPLog.LOG.info("Initializing MappingManager");
            internalLookup = new Lookup();
            regularLookup = new Lookup();
            HashMap<String, String> stringPool = new HashMap<String, String>();
            String[] classMappings = new String(ResourceUtil.getResourceBytesFromJar("/classes.csv", CoreLoadingPlugin.class)).split("\n");
            for (int i = 1; i < classMappings.length; ++i) {
                String[] line = classMappings[i].split(",");
                UniversalClass clazz = new UniversalClass(line, stringPool);
                internalLookup.unwrap(clazz.internalName, clazz);
                regularLookup.unwrap(clazz.regularName, clazz);
            }
            String[] fieldMappings = new String(ResourceUtil.getResourceBytesFromJar("/fields.csv", CoreLoadingPlugin.class)).split("\n");
            for (int i = 1; i < fieldMappings.length; ++i) {
                String[] line = fieldMappings[i].split(",");
                UniversalClass clazz = internalLookup.get(MappingType.Notch, line[0].substring(0, line[0].lastIndexOf(47)));
                UniversalField.createAndAddToParent(clazz, line, stringPool);
            }
            String[] methodMappings = new String(ResourceUtil.getResourceBytesFromJar("/methods.csv", CoreLoadingPlugin.class)).split("\n");
            for (int i = 1; i < methodMappings.length; ++i) {
                String[] line = methodMappings[i].split(",");
                UniversalClass clazz = internalLookup.get(MappingType.Notch, line[0].substring(0, line[0].lastIndexOf(47)));
                UniversalMethod.createAndAddToParent(clazz, line, stringPool);
            }
            lastInitializedAt.set(System.currentTimeMillis());
            cleanupThread.start();
        }
    }

    public static UniversalClass classForName(NameType nameType, MappingType mappingType, String className) throws ClassNotFoundException {
        MappingManager.initialize();
        try {
            switch (nameType) {
                case Internal: {
                    return internalLookup.get(mappingType, className);
                }
                case Regular: {
                    return regularLookup.get(mappingType, className);
                }
            }
            throw new IllegalArgumentException("Invalid enum value " + (Object)((Object)nameType));
        }
        catch (Lookup.LookupException e) {
            throw new ClassNotFoundException("Could not find class \"" + className + "\" with " + nameType.name().toLowerCase() + " name in the " + mappingType.name() + " mapping.");
        }
    }

    public static boolean containsClass(NameType nameType, MappingType mappingType, String className) {
        MappingManager.initialize();
        switch (nameType) {
            case Internal: {
                return internalLookup.containsKey(mappingType, className);
            }
            case Regular: {
                return regularLookup.containsKey(mappingType, className);
            }
        }
        throw new IllegalArgumentException("Invalid enum value " + (Object)((Object)nameType));
    }

    public static UniversalField getField(FieldInsnNode instruction) throws ClassNotFoundException, NoSuchFieldException {
        MappingManager.initialize();
        if (!CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, instruction.owner).getField(MappingType.MCP, instruction.name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " in the MCP mappings. Are you sure it's a Minecraft class? (we're in dev, cannot use SRG or Notch here).");
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, instruction.owner).getField(MappingType.SRG, instruction.name);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, instruction.owner).getField(MappingType.Notch, instruction.name);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " neither in the SRG nor in the Notch mappings. Are you sure it's a Minecraft class? (we're in obf, cannot use MCP here)");
            }
        }
    }

    public static UniversalMethod getMethod(MethodInsnNode instruction) throws ClassNotFoundException, NoSuchMethodException {
        MappingManager.initialize();
        if (!CoreLoadingPlugin.isObfuscated()) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.MCP, instruction.owner).getMethod(MappingType.MCP, instruction.name, instruction.desc);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " in the MCP mappings. Are you sure it's a Minecraft class? (we're in dev, cannot use SRG or Notch here).");
            }
        }
        try {
            return MappingManager.classForName(NameType.Internal, MappingType.SRG, instruction.owner).getMethod(MappingType.SRG, instruction.name, instruction.desc);
        }
        catch (ClassNotFoundException e) {
            try {
                return MappingManager.classForName(NameType.Internal, MappingType.Notch, instruction.owner).getMethod(MappingType.Notch, instruction.name, instruction.desc);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Could not find the class " + instruction.owner + " neither in the SRG nor in the Notch mappings. Are you sure it's a Minecraft class? (we're in obf, cannot use MCP here)");
            }
        }
    }

    static {
        initialized = false;
        MUTEX = new Object();
        lastInitializedAt = new AtomicLong();
    }

    private static class CleanupThread
    extends Thread {
        public CleanupThread() {
            this.setName("MappingManager Cleanup Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Object object = MUTEX;
                synchronized (object) {
                    long time = System.currentTimeMillis();
                    long lastInit = lastInitializedAt.get();
                    if (time - lastInit >= 10000L) {
                        FPLog.LOG.info("Terminating MappingManager");
                        internalLookup = null;
                        regularLookup = null;
                        initialized = false;
                        return;
                    }
                }
            }
        }
    }
}

