/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.util;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class LangUtil {
    public static final String DEFAULT_LOCALE = "en_US";
    private static final ThreadLocal<HashMap<String, String>> tempMap = ThreadLocal.withInitial(HashMap::new);

    public static void defaultLocalization(@NonNull Map<String, String> localeMap) {
        if (localeMap == null) {
            throw new NullPointerException("localeMap is marked non-null but is null");
        }
        localeMap.forEach(LangUtil::defaultLocalization);
    }

    public static void defaultLocalization(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (!LanguageRegistry.instance().getStringLocalization(key, DEFAULT_LOCALE).isEmpty()) {
            return;
        }
        HashMap<String, String> map = tempMap.get();
        map.put(key, value);
        LanguageRegistry.instance().injectLanguage(DEFAULT_LOCALE, map);
        map.clear();
    }

    @Generated
    private LangUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

