/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.util;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.ChunkPosition;

public class ProtoUtils {
    public static void writePositions(ByteBuf buf, List<ChunkPosition> positions) {
        buf.writeInt(positions.size());
        for (ChunkPosition pos : positions) {
            buf.writeInt(pos.field_151329_a);
            buf.writeByte(pos.field_151327_b);
            buf.writeInt(pos.field_151328_c);
        }
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        try {
            packetBuffer.func_150788_a(stack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<ChunkPosition> readPositions(ByteBuf buf) {
        ArrayList<ChunkPosition> positions = new ArrayList<ChunkPosition>();
        for (int amount = buf.readInt(); amount > 0; --amount) {
            int x = buf.readInt();
            short y = buf.readUnsignedByte();
            int z = buf.readInt();
            positions.add(new ChunkPosition(x, (int)y, z));
        }
        return positions;
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        try {
            return packetBuffer.func_150791_c();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

