/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.crafting;

import java.util.ArrayList;
import makeo.gadomancy.common.familiar.FamiliarAugment;
import makeo.gadomancy.common.items.baubles.ItemEtherealFamiliar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;

public class EtherealFamiliarUpgradeRecipe
extends InfusionRecipe {
    private final FamiliarAugment toAdd;
    private final int requiredPreviousLevel;
    private final Object cachedOutput;

    public EtherealFamiliarUpgradeRecipe(String research, int inst, AspectList aspects2, ItemStack familiarIn, FamiliarAugment toAdd, int reqPrev, ItemStack ... surroundings) {
        super(research, null, inst, aspects2, familiarIn, surroundings);
        this.toAdd = toAdd;
        this.requiredPreviousLevel = reqPrev;
        this.cachedOutput = super.getRecipeOutput();
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack in, World world, EntityPlayer player) {
        if (in == null || !(in.func_77973_b() instanceof ItemEtherealFamiliar)) {
            return false;
        }
        if (this.getRecipeInput() == null || !(this.getRecipeInput().func_77973_b() instanceof ItemEtherealFamiliar)) {
            return false;
        }
        if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.research)) {
            return false;
        }
        FamiliarAugment.FamiliarAugmentList list = ItemEtherealFamiliar.getAugments(in);
        int level = list.contains(this.toAdd) ? list.getLevel(this.toAdd) : 0;
        if (this.requiredPreviousLevel > level) {
            return false;
        }
        if (!this.toAdd.checkConditions(list, level + 1)) {
            return false;
        }
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (ItemStack comp : this.getComponents()) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                ItemStack inCopy = ((ItemStack)ii.get(a)).func_77946_l();
                if (comp.func_77960_j() == Short.MAX_VALUE) {
                    inCopy.func_77964_b(Short.MAX_VALUE);
                }
                if (!InfusionRecipe.areItemStacksEqual((ItemStack)inCopy, (ItemStack)comp, (boolean)true)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return true;
    }

    public Object getRecipeOutput(ItemStack input) {
        ItemStack inputCopy = input.func_77946_l();
        ItemEtherealFamiliar.incrementAugmentLevel(inputCopy, this.toAdd);
        return inputCopy;
    }

    public Object getRecipeOutput() {
        return this.cachedOutput;
    }
}

