/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.events;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import makeo.gadomancy.common.registration.RegisteredEnchantments;
import makeo.gadomancy.common.registration.RegisteredPotions;
import makeo.gadomancy.common.utils.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.config.ConfigItems;

public class EventHandlerRedirect {
    private static final ItemStack ITEM_GOGGLES = new ItemStack(ConfigItems.itemGoggles);
    private static boolean hasChanged;
    private static ItemStack oldItem;

    public static void addGoggles(Entity entity) {
        if (entity instanceof EntityPlayer && EventHandlerRedirect.hasGoggles((EntityPlayer)entity)) {
            ItemStack[] armorInv = ((EntityPlayer)entity).field_71071_by.field_70460_b;
            oldItem = armorInv[3];
            hasChanged = true;
            armorInv[3] = ITEM_GOGGLES;
        }
    }

    public static void removeGoggles(Entity entity) {
        if (hasChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71071_by.field_70460_b[3] = oldItem;
            oldItem = null;
            hasChanged = false;
        }
    }

    private static boolean hasGoggles(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70440_f(3);
        if (MiscUtils.isANotApprovedOrMisunderstoodPersonFromMoreDoor(player)) {
            return true;
        }
        return stack != null && EnchantmentHelper.func_77506_a((int)RegisteredEnchantments.revealer.field_77352_x, (ItemStack)stack) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void preNodeRender(TileEntity tile) {
        EventHandlerRedirect.addGoggles((Entity)Minecraft.func_71410_x().field_71451_h);
    }

    @SideOnly(value=Side.CLIENT)
    public static void postNodeRender(TileEntity tile) {
        EventHandlerRedirect.removeGoggles((Entity)Minecraft.func_71410_x().field_71451_h);
    }

    public static void preBlockHighlight(DrawBlockHighlightEvent event) {
        EventHandlerRedirect.addGoggles((Entity)event.player);
    }

    public static void postBlockHighlight(DrawBlockHighlightEvent event) {
        EventHandlerRedirect.removeGoggles((Entity)event.player);
    }

    public static int getAdditionalVisDiscount(EntityPlayer player, Aspect aspect, int currentTotalDiscount) {
        if (player.func_70644_a((Potion)RegisteredPotions.VIS_DISCOUNT)) {
            currentTotalDiscount += (player.func_70660_b((Potion)RegisteredPotions.VIS_DISCOUNT).func_76458_c() + 1) * 8;
        }
        return currentTotalDiscount;
    }

    public static int getFortuneLevel(EntityLivingBase entity) {
        int fortuneLevel = EventHandlerRedirect.getRealEnchantmentLevel(Enchantment.field_77346_s.field_77352_x, entity.func_70694_bm());
        if (entity.func_70644_a((Potion)RegisteredPotions.POTION_LUCK)) {
            int lvl = entity.func_70660_b((Potion)RegisteredPotions.POTION_LUCK).func_76458_c() + 1;
            fortuneLevel += lvl;
        }
        return fortuneLevel;
    }

    public static int getLootingLevel(EntityLivingBase entity) {
        int lootingLevel = EventHandlerRedirect.getRealEnchantmentLevel(Enchantment.field_77335_o.field_77352_x, entity.func_70694_bm());
        if (entity.func_70644_a((Potion)RegisteredPotions.POTION_LUCK)) {
            int lvl = entity.func_70660_b((Potion)RegisteredPotions.POTION_LUCK).func_76458_c() + 1;
            lootingLevel += lvl;
        }
        return lootingLevel;
    }

    public static int onGetEnchantmentLevel(int enchantmentId, ItemStack stack) {
        MinecraftServer server;
        EntityPlayer possiblePlayer = null;
        if (stack != null && (server = MinecraftServer.func_71276_C()) != null && server.func_71203_ab() != null) {
            for (EntityPlayer player : server.func_71203_ab().field_72404_b) {
                if (player == null || player.func_70694_bm() != stack) continue;
                possiblePlayer = player;
                break;
            }
        }
        if (possiblePlayer != null) {
            if (enchantmentId == Enchantment.field_77346_s.field_77352_x) {
                return EventHandlerRedirect.getFortuneLevel(possiblePlayer);
            }
            if (enchantmentId == Enchantment.field_77335_o.field_77352_x) {
                return EventHandlerRedirect.getLootingLevel(possiblePlayer);
            }
        }
        return EventHandlerRedirect.getRealEnchantmentLevel(enchantmentId, stack);
    }

    private static int getRealEnchantmentLevel(int enchantmentId, ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        NBTTagList nbttaglist = stack.func_77986_q();
        if (nbttaglist == null) {
            return 0;
        }
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            short id = nbttaglist.func_150305_b(j).func_74765_d("id");
            if (id != enchantmentId) continue;
            return nbttaglist.func_150305_b(j).func_74765_d("lvl");
        }
        return 0;
    }
}

