/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.client;

import com.gtnewhorizons.gravisuiteneo.GraviSuiteNeo;
import com.gtnewhorizons.gravisuiteneo.client.ICustomItemBars;
import com.gtnewhorizons.gravisuiteneo.util.ColorUtil;
import com.gtnewhorizons.gravisuiteneo.util.RenderUtil;
import com.gtnewhorizons.gravisuiteneo.util.vector.Vector4f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCustomItemBar
implements IItemRenderer {
    private final RenderItem renderItem = new RenderItem();
    private static final int START_TOP = 2;
    private static final int START_BOTTOM = 14;
    private static final int START_LEFT = 2;
    private static final int START_RIGHT = 14;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (data != null && data.length > 0) {
            this.renderToInventory(item);
        }
    }

    public void renderToInventory(ItemStack itemStack) {
        int thicknessPrefixMultiplicator;
        int currentPosXY;
        Minecraft mc = Minecraft.func_71410_x();
        this.renderItem.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), itemStack, 0, 0, true);
        if (!(itemStack.func_77973_b() instanceof ICustomItemBars)) {
            return;
        }
        ICustomItemBars barsItem = (ICustomItemBars)itemStack.func_77973_b();
        int maxBars = barsItem.getNumBars(itemStack);
        ICustomItemBars.BarAlignment alignment = barsItem.getBarAlignment();
        boolean isVertical = false;
        switch (alignment) {
            case BOTTOM: {
                currentPosXY = 14;
                thicknessPrefixMultiplicator = -1;
                break;
            }
            case TOP: {
                currentPosXY = 2;
                thicknessPrefixMultiplicator = 1;
                break;
            }
            case LEFT: {
                currentPosXY = 2;
                thicknessPrefixMultiplicator = 1;
                isVertical = true;
                break;
            }
            case RIGHT: {
                currentPosXY = 14;
                thicknessPrefixMultiplicator = -1;
                isVertical = true;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < maxBars; ++i) {
            double barValue = barsItem.getValueForBar(itemStack, i);
            int thickness = barsItem.getBarThickness(itemStack, i);
            if (barValue > -1.0) {
                double barMax = barsItem.getMaxValue(itemStack, i);
                Color colorFull = barsItem.getColorForMaxValue(itemStack, i);
                Color colorEmpty = barsItem.getColorForMinValue(itemStack, i);
                boolean tInverted = barsItem.getIsBarInverted(itemStack, i);
                this.renderBar(currentPosXY, barMax, barValue, colorFull, colorEmpty, thickness, isVertical, tInverted);
            }
            if ((currentPosXY += thickness * thicknessPrefixMultiplicator) > 0 && currentPosXY < 15) continue;
            GraviSuiteNeo.LOGGER.warn("[CustomBarItemRenderer] Index violates boundary limits");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBar(int xyStart, double maxDamage, double dispDamage, Color colorFull, Color colorEmpty, int thickness, boolean vertical, boolean inverted) {
        try {
            int tBgBarHeight;
            int tBgBarWidth;
            int tFgBarHeight;
            int tFgBarWidth;
            boolean tBarZ;
            int tBarY;
            int tBarX;
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double ratio = dispDamage / maxDamage;
            Vector4f fgColor = ColorUtil.toFloat(inverted ? colorEmpty : colorFull);
            Vector4f ec = ColorUtil.toFloat(inverted ? colorFull : colorEmpty);
            fgColor.interpolate(ec, (float)ratio);
            Vector4f bgColor = ColorUtil.toFloat(Color.black);
            bgColor.interpolate(fgColor, 0.15f);
            int barLenght = inverted ? (int)Math.round(12.0 * ratio) : (int)Math.round(12.0 * (1.0 - ratio));
            if (vertical) {
                tBarX = xyStart;
                tBarY = 2;
                tBarZ = false;
                tFgBarWidth = thickness;
                tFgBarHeight = barLenght;
                tBgBarWidth = thickness;
                tBgBarHeight = 12;
            } else {
                tBarX = 2;
                tBarY = xyStart;
                tBarZ = false;
                tFgBarWidth = barLenght;
                tFgBarHeight = thickness;
                tBgBarWidth = 12;
                tBgBarHeight = thickness;
            }
            RenderUtil.renderQuad2D((double)tBarX, (double)tBarY, (double)tBarZ, (double)tBgBarWidth, (double)tBgBarHeight, bgColor);
            RenderUtil.renderQuad2D((double)tBarX, (double)tBarY, (double)tBarZ, (double)tFgBarWidth, (double)tFgBarHeight, fgColor);
        }
        catch (Exception exception) {
        }
        finally {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
        }
    }
}

