/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.casing;

import bartworks.API.BorosilicateGlass;
import bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizon.gtnhlib.util.data.BlockSupplier;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.casing.ICasing;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.ISuperChestAcceptor;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockCasings4;
import gregtech.common.blocks.BlockCasings8;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import gtPlusPlus.core.block.ModBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;

public enum Casings implements ICasing
{
    ThermalProcessingCasing(() -> ModBlocks.blockCasings2Misc, 0, Casings.gtpp(1, 0)),
    HastelloyNSealantBlock(() -> ModBlocks.blockCasings2Misc, 1, Casings.gtpp(1, 1)),
    HastelloyXStructuralBlock(() -> ModBlocks.blockCasings2Misc, 2, Casings.gtpp(1, 2)),
    IncoloyDSFluidContainmentBlock(() -> ModBlocks.blockCasings2Misc, 3, Casings.gtpp(1, 3)),
    WashPlantCasing(() -> ModBlocks.blockCasings2Misc, 4, -1),
    IndustrialSieveCasing(() -> ModBlocks.blockCasings2Misc, 5, Casings.gtpp(1, 5)),
    LargeSieveGrate(() -> ModBlocks.blockCasings2Misc, 6, Casings.gtpp(1, 6)),
    VanadiumRedoxPowerCellEV(() -> ModBlocks.blockCasings2Misc, 7, Casings.gtpp(1, 7)),
    SubStationExternalCasing(() -> ModBlocks.blockCasings2Misc, 8, Casings.gtpp(1, 8)),
    CyclotronCoil(() -> ModBlocks.blockCasings2Misc, 9, Casings.gtpp(1, 9)),
    CyclotronOuterCasing(() -> ModBlocks.blockCasings2Misc, 10, -1),
    ThermalContainmentCasing(() -> ModBlocks.blockCasings2Misc, 11, -1),
    BulkProductionFrame(() -> ModBlocks.blockCasings2Misc, 12, -1),
    CuttingFactoryFrame(() -> ModBlocks.blockCasings2Misc, 13, Casings.gtpp(1, 13)),
    SterileFarmCasing(() -> ModBlocks.blockCasings2Misc, 15, Casings.gtpp(1, 15)),
    YellowStripesBlockA(() -> GregTechAPI.sBlockCasings3, 0, Casings.gt(0, 2, 0)),
    YellowStripesBlockB(() -> GregTechAPI.sBlockCasings3, 1, Casings.gt(0, 2, 1)),
    RadioactiveHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 2, Casings.gt(0, 2, 2)),
    BioHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 3, Casings.gt(0, 2, 3)),
    ExplosionHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 4, Casings.gt(0, 2, 4)),
    FireHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 5, Casings.gt(0, 2, 5)),
    AcidHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 6, Casings.gt(0, 2, 6)),
    MagicHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 7, Casings.gt(0, 2, 7)),
    FrostHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 8, Casings.gt(0, 2, 8)),
    NoiseHazardSignBlock(() -> GregTechAPI.sBlockCasings3, 9, Casings.gt(0, 2, 9)),
    GrateMachineCasing(() -> GregTechAPI.sBlockCasings3, 10, Casings.gt(0, 2, 10)),
    FilterMachineCasing(() -> GregTechAPI.sBlockCasings3, 11, Casings.gt(0, 2, 11)),
    RadiationProofMachineCasing(() -> GregTechAPI.sBlockCasings3, 12, Casings.gt(0, 2, 12)),
    BronzeFireboxCasing(() -> GregTechAPI.sBlockCasings3, 13, Casings.gt(0, 2, 13)),
    SteelFireboxCasing(() -> GregTechAPI.sBlockCasings3, 14, Casings.gt(0, 2, 14)),
    TungstensteelFireboxCasing(() -> GregTechAPI.sBlockCasings3, 15, Casings.gt(0, 2, 15)),
    MiningOsmiridiumCasing(() -> GregTechAPI.sBlockCasings4, 14, ((BlockCasings4)GregTechAPI.sBlockCasings4).getTextureIndex(14)),
    BoltedOsmiridiumCasing(() -> WerkstoffLoader.BWBlockCasings, 32083, 32083),
    ReboltedOsmiridiumCasing(() -> WerkstoffLoader.BWBlockCasingsAdvanced, 32083, 32083),
    MiningBlackPlutoniumCasing(() -> GregTechAPI.sBlockCasings8, 3, ((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(3)),
    BoltedNaquadahAlloyCasing(() -> WerkstoffLoader.BWBlockCasings, 32091, 32091),
    ReboltedNaquadahAlloyCasing(() -> WerkstoffLoader.BWBlockCasingsAdvanced, 32091, 32091),
    MiningNeutroniumCasing(() -> GregTechAPI.sBlockCasings8, 2, ((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(2)),
    BoltedIridiumCasing(() -> WerkstoffLoader.BWBlockCasings, 31850, 31850),
    ReboltedIridiumCasing(() -> WerkstoffLoader.BWBlockCasingsAdvanced, 31850, 31850),
    TinItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 0, Casings.gt(16, 4, 0)),
    BrassItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 1, Casings.gt(16, 4, 1)),
    ElectrumItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 2, Casings.gt(16, 4, 2)),
    PlatinumItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 3, Casings.gt(16, 4, 3)),
    OsmiumItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 4, Casings.gt(16, 4, 4)),
    QuantiumItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 5, Casings.gt(16, 4, 5)),
    FluxedElectrumItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 6, Casings.gt(16, 4, 6)),
    BlackPlutoniumItemPipeCasing(() -> GregTechAPI.sBlockCasings11, 7, Casings.gt(16, 4, 7)),
    AlchemicalCasing(() -> GregTechAPI.sBlockCasings12, 10, Casings.gt(16, 5, 10)){

        @Override
        public String getLocalizedName() {
            return GTUtility.translate("GT5U.MBTT.AlchemyCasingAny", new Object[0]);
        }

        @Override
        public <T> int getTextureId(T t, ICasing.CasingElementContext<T> context) {
            int n;
            int tier = GTUtility.clamp(context.getInstance(t).getCasingTier(context.getGroup(), 0), 0, 2);
            switch (tier) {
                case 1: {
                    n = Casings.gt(16, 91);
                    break;
                }
                case 2: {
                    n = Casings.gt(16, 92);
                    break;
                }
                default: {
                    n = Casings.gt(16, 90);
                }
            }
            return n;
        }

        @Override
        public <T> IStructureElement<T> asElement(ICasing.CasingElementContext<T> context) {
            return StructureUtility.ofBlocksTiered((block, meta) -> {
                Integer n;
                if (block != GregTechAPI.sBlockCasings12) {
                    return null;
                }
                switch (meta) {
                    case 10: {
                        n = 0;
                        break;
                    }
                    case 11: {
                        n = 1;
                        break;
                    }
                    case 12: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = null;
                    }
                }
                return n;
            }, Arrays.asList(Pair.of((Object)GregTechAPI.sBlockCasings12, (Object)10), Pair.of((Object)GregTechAPI.sBlockCasings12, (Object)11), Pair.of((Object)GregTechAPI.sBlockCasings12, (Object)12)), null, (multi, tier) -> ((IStructureProvider)multi).getStructureInstance().setCasingTier(context.getGroup(), (int)tier), multi -> {
                int tier = ((IStructureProvider)multi).getStructureInstance().getCasingTier(context.getGroup(), -1);
                return tier == -1 ? null : Integer.valueOf(tier);
            });
        }

        @Override
        public boolean isTiered() {
            return true;
        }
    }
    ,
    AlchemicalConstructTiered(() -> GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockMetalDevice"), 9, -1){

        @Override
        public String getLocalizedName() {
            return GTUtility.translate("GT5U.MBTT.AlchemicalConstructAny", new Object[0]);
        }

        @Override
        public <T> ITexture getCasingTexture(T t, ICasing.CasingElementContext<T> context) {
            int tier = GTUtility.clamp(context.getInstance(t).getCasingTier(context.getGroup(), 0), 0, 1);
            if (tier == 0) {
                return TextureFactory.builder().setFromBlock(this.getBlock(), 9).build();
            }
            return TextureFactory.builder().setFromBlock(this.getBlock(), 3).build();
        }

        @Override
        public <T> IStructureElement<T> asElement(ICasing.CasingElementContext<T> context) {
            return StructureUtility.ofBlocksTiered((block, meta) -> {
                Integer n;
                if (block != this.getBlock()) {
                    return null;
                }
                switch (meta) {
                    case 9: {
                        n = 0;
                        break;
                    }
                    case 3: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = null;
                    }
                }
                return n;
            }, Arrays.asList(Pair.of((Object)this.getBlock(), (Object)9), Pair.of((Object)this.getBlock(), (Object)3)), null, (multi, tier) -> ((IStructureProvider)multi).getStructureInstance().setCasingTier(context.getGroup(), (int)tier), multi -> {
                int tier = ((IStructureProvider)multi).getStructureInstance().getCasingTier(context.getGroup(), -1);
                return tier == -1 ? null : Integer.valueOf(tier);
            });
        }

        @Override
        public boolean isTiered() {
            return true;
        }
    }
    ,
    ChemicalGradeGlass(() -> GregTechAPI.sBlockGlass1, 0, Casings.gt(16, 0, 0)),
    ElectronPermeableNeutroniumCoatedGlass(() -> GregTechAPI.sBlockGlass1, 1, Casings.gt(16, 0, 1)),
    OmniPurposeInfinityFusedGlass(() -> GregTechAPI.sBlockGlass1, 2, Casings.gt(16, 0, 2)),
    NonPhotonicMatterExclusionGlass(() -> GregTechAPI.sBlockGlass1, 3, Casings.gt(16, 0, 3)),
    HawkingRadiationRealignmentFocus(() -> GregTechAPI.sBlockGlass1, 4, Casings.gt(16, 0, 4)),
    FusionMachineCasingMKIV(() -> ModBlocks.blockCasings6Misc, 0, Casings.gtpp(3, 4)),
    AdvancedFusionCoilII(() -> ModBlocks.blockCasings6Misc, 1, Casings.gtpp(3, 5)),
    MagicCasing(() -> Loaders.magicCasing, 0, -1),
    BorosilicateGlassAny(BorosilicateGlass::getGlassBlock, 0, -1){

        @Override
        public String getLocalizedName() {
            return GTUtility.translate("GT5U.MBTT.BoroGlassAny", new Object[0]);
        }

        @Override
        public <T> IStructureElement<T> asElement(ICasing.CasingElementContext<T> context) {
            return BorosilicateGlass.ofBoroGlassAnyTier();
        }
    }
    ,
    BorosilicateGlassTiered(BorosilicateGlass::getGlassBlock, 0, -1){

        @Override
        public String getLocalizedName() {
            return GTUtility.translate("GT5U.MBTT.BoroGlassTiered", new Object[0]);
        }

        @Override
        public <T> IStructureElement<T> asElement(ICasing.CasingElementContext<T> context) {
            return BorosilicateGlass.ofBoroGlass((byte)-2, (multi, tier) -> context.getInstance(multi).setCasingTier(context.getGroup(), tier.byteValue()), multi -> (byte)context.getInstance(multi).getCasingTier(context.getGroup(), -2));
        }

        @Override
        public boolean isTiered() {
            return true;
        }
    }
    ,
    WardedGlass(() -> GameRegistry.findBlock((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque"), 2, -1),
    SuperChest(() -> GregTechAPI.sBlockMachines, 0, -1){

        @Override
        public String getLocalizedName() {
            return GTUtility.translate("GT5U.MBTT.SuperChest", new Object[0]);
        }

        @Override
        public boolean isTiered() {
            return true;
        }

        @Override
        public <T> IStructureElement<T> asElement(ICasing.CasingElementContext<T> context) {
            List<MTEDigitalChestBase> tiers = GTStructureUtility.extractMTEs(MTEDigitalChestBase.class, ItemList.Super_Chest_LV.get(1L, new Object[0]), ItemList.Super_Chest_MV.get(1L, new Object[0]), ItemList.Super_Chest_HV.get(1L, new Object[0]), ItemList.Super_Chest_EV.get(1L, new Object[0]), ItemList.Super_Chest_IV.get(1L, new Object[0]), ItemList.Quantum_Chest_LV.get(1L, new Object[0]), ItemList.Quantum_Chest_MV.get(1L, new Object[0]), ItemList.Quantum_Chest_HV.get(1L, new Object[0]), ItemList.Quantum_Chest_EV.get(1L, new Object[0]), ItemList.Quantum_Chest_IV.get(1L, new Object[0]));
            return StructureUtility.lazy(() -> GTStructureUtility.ofGenericMTETiered(MTEDigitalChestBase.class, (t, mte, tier) -> ((ISuperChestAcceptor)t).onSuperChestAdded(context.getGroup(), (MTEDigitalChestBase)mte, tier), tiers));
        }
    }
    ,
    QuantumGlass(() -> BlockQuantumGlass.INSTANCE, 0, -1),
    HighPowerCasing(() -> TTCasingsContainer.sBlockCasingsTT, 0, Casings.tt(0)),
    ComputerCasing(() -> TTCasingsContainer.sBlockCasingsTT, 1, Casings.tt(1)),
    ComputerHeatVent(() -> TTCasingsContainer.sBlockCasingsTT, 2, Casings.tt(2)),
    AdvancedComputerCasing(() -> TTCasingsContainer.sBlockCasingsTT, 3, Casings.tt(3)),
    MolecularCasing(() -> TTCasingsContainer.sBlockCasingsTT, 4, Casings.tt(4)),
    AdvancedMolecularCasing(() -> TTCasingsContainer.sBlockCasingsTT, 5, Casings.tt(5)),
    ContainmentFieldGenerator(() -> TTCasingsContainer.sBlockCasingsTT, 6, Casings.tt(6)),
    MolecularCoil(() -> TTCasingsContainer.sBlockCasingsTT, 7, Casings.tt(7)),
    HollowCasing(() -> TTCasingsContainer.sBlockCasingsTT, 8, Casings.tt(8)),
    SpacetimeAlteringCasing(() -> TTCasingsContainer.sBlockCasingsTT, 9, Casings.tt(9)),
    TeleportationCasing(() -> TTCasingsContainer.sBlockCasingsTT, 10, Casings.tt(10)),
    DimensionalBridgeGenerator(() -> TTCasingsContainer.sBlockCasingsTT, 11, Casings.tt(11)),
    UltimateMolecularCasing(() -> TTCasingsContainer.sBlockCasingsTT, 12, Casings.tt(12)),
    UltimateAdvancedMolecularCasing(() -> TTCasingsContainer.sBlockCasingsTT, 13, Casings.tt(13)),
    UltimateContainmentFieldGenerator(() -> TTCasingsContainer.sBlockCasingsTT, 14, Casings.tt(14));

    public final BlockSupplier blockGetter;
    private volatile Block block;
    public final int meta;
    public final int textureId;

    private Casings(BlockSupplier blockGetter, int meta, int textureId) {
        this.blockGetter = blockGetter;
        this.meta = meta;
        this.textureId = textureId;
    }

    @NotNull
    public Block getBlock() {
        if (this.block == null) {
            this.block = Objects.requireNonNull((Block)this.blockGetter.get(), "Block for casing " + this.name() + " was null");
        }
        return this.block;
    }

    public int getBlockMeta() {
        return this.meta;
    }

    @Override
    public int getTextureId() {
        if (this.textureId == -1) {
            throw new UnsupportedOperationException("Casing " + this.name() + " does not have a casing texture; The result of getTextureId() is undefined.");
        }
        return this.textureId;
    }

    @Override
    public boolean isTiered() {
        return false;
    }

    private static int gt(int page, int id) {
        return page * 128 + id;
    }

    private static int gt(int page, int casing, int id) {
        return page * 128 + casing * 16 + id;
    }

    private static int gtpp(int page, int id) {
        int aRealID = id + page * 16;
        return 64 + aRealID;
    }

    private static int tt(int id) {
        return 1024 + id;
    }
}

