/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface IRecipeMap {
    @Nonnull
    public Collection<GTRecipe> doAdd(GTRecipeBuilder var1);

    default public IRecipeMap deepCopyInput() {
        return IRecipeMap.newRecipeMap(b -> this.doAdd(b.copy()));
    }

    public static IRecipeMap newRecipeMap(final Function<? super GTRecipeBuilder, Collection<GTRecipe>> func) {
        return new IRecipeMap(){

            @Override
            @Nonnull
            public Collection<GTRecipe> doAdd(GTRecipeBuilder builder) {
                ArrayList<Collection<Collection>> ret = new ArrayList<Collection<Collection>>();
                Collection out = (Collection)func.apply(builder);
                ret.add(out);
                builder.clearInvalid();
                return GTUtility.concat(ret);
            }
        };
    }
}

