/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.list.array.TIntArrayList;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.modularui2.GTGuiTheme;
import gregtech.api.modularui2.GTGuiThemes;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.modularui2.GTModularScreen;
import gregtech.api.modularui2.MetaTileEntityGuiHandler;
import gregtech.api.render.ISBRInventoryContext;
import gregtech.api.render.ISBRWorldContext;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonMetaTileEntity
implements IMetaTileEntity {
    public final ItemStack[] mInventory;
    public final String mName;
    public boolean doTickProfilingInThisTick = true;
    public long mSoundRequests = 0L;

    protected CommonMetaTileEntity(int id, String basicName, String regionalName, int invSlotCount) {
        if (GregTechAPI.sPostloadStarted || !GregTechAPI.sPreloadStarted) {
            throw new IllegalAccessError("This Constructor has to be called in the load Phase");
        }
        if (GregTechAPI.METATILEENTITIES[id] != null) {
            IMetaTileEntity existing = GregTechAPI.METATILEENTITIES[id];
            throw new IllegalArgumentException("MetaTileEntity id " + id + " is already occupied! Existing MTE is " + existing.getMetaName() + "(" + existing.getClass().getCanonicalName() + ").");
        }
        GregTechAPI.METATILEENTITIES[id] = this;
        this.mInventory = new ItemStack[invSlotCount];
        this.mName = basicName.replace(" ", "_").toLowerCase(Locale.ENGLISH);
        GTLanguageManager.addStringLocalization("gt.blockmachines." + this.mName + ".name", regionalName);
    }

    protected CommonMetaTileEntity(String name, int invSlotCount) {
        this.mInventory = new ItemStack[invSlotCount];
        this.mName = name;
    }

    @Nullable
    public <T> T getCapability(@NotNull Class<T> capability, @NotNull ForgeDirection side) {
        return null;
    }

    @Override
    public void onServerStart() {
    }

    @Override
    public void onConfigLoad() {
    }

    @Override
    public void setItemNBT(NBTTagCompound nbt) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister blockIconRegister) {
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return true;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity baseMetaTileEntity) {
    }

    @Override
    public void onPreTick(IGregTechTileEntity baseMetaTileEntity, long tick) {
    }

    @Override
    public void onPostTick(IGregTechTileEntity baseMetaTileEntity, long tick) {
        if (baseMetaTileEntity.isClientSide() && GTMod.clientProxy().changeDetected() == 4) {
            baseMetaTileEntity.issueTextureUpdate();
        }
    }

    public void onTickFail(IGregTechTileEntity baseMetaTileEntity, long tick) {
    }

    public void onSetActive(boolean active) {
    }

    public void onEnableWorking() {
    }

    public void onDisableWorking() {
    }

    @Override
    public void inValidate() {
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void initDefaultModes(NBTTagCompound nbt) {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity baseMetaTileEntity, EntityPlayer player, ForgeDirection side, float x, float y, float z) {
        return false;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity baseMetaTileEntity, EntityPlayer player) {
    }

    @Override
    public void onValueUpdate(byte value) {
    }

    @Override
    public byte getUpdateData() {
        return 0;
    }

    @Override
    public void doSound(byte index, double x, double y, double z) {
    }

    @Override
    public void startSoundLoop(byte index, double x, double y, double z) {
    }

    @Override
    public void stopSoundLoop(byte value, double x, double y, double z) {
    }

    @Override
    public final void sendSound(byte aIndex) {
        if (!this.getBaseMetaTileEntity().isMuffled()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)4, aIndex);
        }
    }

    @Override
    public final void sendLoopStart(byte aIndex) {
        if (!this.getBaseMetaTileEntity().isMuffled()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)5, aIndex);
        }
        ++this.mSoundRequests;
    }

    @Override
    public final void sendLoopEnd(byte aIndex) {
        if (!this.getBaseMetaTileEntity().isMuffled()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)6, aIndex);
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isValidSlot(int index) {
        return true;
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return true;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int index) {
        return false;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity baseMetaTileEntity, EntityPlayer player, int logLevel, ArrayList<String> list) {
        return list;
    }

    @Override
    public ArrayList<ItemStack> getDroppedItem() {
        return null;
    }

    public FluidStack getFluid() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int getCapacity() {
        return 0;
    }

    public int getProgresstime() {
        return 0;
    }

    public int maxProgresstime() {
        return 0;
    }

    public int increaseProgress(int progress) {
        return 0;
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    @Override
    public void receiveClientEvent(byte eventID, byte value) {
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }

    @Override
    public String getSpecialVoltageToolTip() {
        return null;
    }

    public boolean isDigitalChest() {
        return false;
    }

    public ItemStack[] getStoredItemData() {
        return null;
    }

    public void setItemCount(int count) {
    }

    public int getMaxItemCount() {
        return 0;
    }

    public int func_70302_i_() {
        return this.mInventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.mInventory.length) {
            return this.mInventory[index];
        }
        return null;
    }

    public ItemStack getFirstStack() {
        for (int index = 0; index < this.mInventory.length; ++index) {
            ItemStack stackInSlot = this.func_70301_a(index);
            if (stackInSlot == null) continue;
            return stackInSlot;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (index >= 0 && index < this.mInventory.length) {
            this.mInventory[index] = itemStack;
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        if (GregTechAPI.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()] != null) {
            return GregTechAPI.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()].getMetaName();
        }
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return this.getBaseMetaTileEntity().isValidSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack tStack = this.func_70301_a(index);
        ItemStack rStack = GTUtility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= amount) {
                if (this.setStackToZeroInsteadOfNull(index)) {
                    tStack.field_77994_a = 0;
                    this.func_70296_d();
                } else {
                    this.func_70299_a(index, null);
                }
            } else {
                rStack = tStack.func_77979_a(amount);
                this.func_70296_d();
                if (tStack.field_77994_a == 0 && !this.setStackToZeroInsteadOfNull(index)) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return rStack;
    }

    public int[] func_94128_d(int ordinalSide) {
        TIntArrayList tList = new TIntArrayList();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity();
        Cover tileCover = tTileEntity.getCoverAtSide(ForgeDirection.getOrientation((int)ordinalSide));
        boolean tSkip = tileCover.letsItemsIn(-2) || tileCover.letsItemsOut(-2);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isValidSlot(i) || !tSkip && !tileCover.letsItemsOut(i) && !tileCover.letsItemsIn(i)) continue;
            tList.add(i);
        }
        return tList.toArray();
    }

    public boolean func_102007_a(int index, ItemStack itemStack, int ordinalSide) {
        return this.isValidSlot(index) && itemStack != null && index < this.mInventory.length && (this.mInventory[index] == null || GTUtility.areStacksEqual(itemStack, this.mInventory[index])) && this.allowPutStack(this.getBaseMetaTileEntity(), index, ForgeDirection.getOrientation((int)ordinalSide), itemStack);
    }

    public boolean func_102008_b(int index, ItemStack itemStack, int ordinalSide) {
        return this.isValidSlot(index) && itemStack != null && index < this.mInventory.length && this.allowPullStack(this.getBaseMetaTileEntity(), index, ForgeDirection.getOrientation((int)ordinalSide), itemStack);
    }

    public boolean canFill(ForgeDirection side, Fluid fluid) {
        return this.fill(side, new FluidStack(fluid, 1), false) == 1;
    }

    public boolean canDrain(ForgeDirection side, Fluid fluid) {
        return this.drain(side, new FluidStack(fluid, 1), false) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().isSteampowered()) {
            return GTValues.emptyFluidTankInfo;
        }
        return new FluidTankInfo[]{this.getInfo()};
    }

    public FluidStack drain(ForgeDirection side, FluidStack fluidStack, boolean doDrain) {
        if (this.getFluid() != null && fluidStack != null && this.getFluid().isFluidEqual(fluidStack)) {
            return this.drain(fluidStack.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection side, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public int getFluidAmount() {
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    @Override
    public String getMetaName() {
        return this.mName;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    @Override
    public boolean doTickProfilingMessageDuringThisTick() {
        return this.doTickProfilingInThisTick;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean connectsToItemPipe(ForgeDirection side) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public ItemStack[] getRealInventory() {
        return this.mInventory;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInInventory(ISBRInventoryContext ctx) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(ISBRWorldContext ctx) {
        return false;
    }

    @Override
    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        if (axisalignedbb1 != null && inputAABB.func_72326_a(axisalignedbb1)) {
            outputAABB.add(axisalignedbb1);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity collider) {
    }

    @Override
    public void onCreated(ItemStack itemStack, World world, EntityPlayer player) {
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    @Override
    public boolean hasAlternativeModeText() {
        return false;
    }

    @Override
    public String getAlternativeModeText() {
        return "";
    }

    public void openGui(EntityPlayer player) {
        if (GTGuis.GLOBAL_SWITCH_MUI2 && this.useMui2() || this.forceUseMui2()) {
            if (!NetworkUtils.isClient((EntityPlayer)player)) {
                MetaTileEntityGuiHandler.open(player, this);
            }
        } else {
            GTUIInfos.openGTTileEntityUI(this.getBaseMetaTileEntity(), player);
        }
        this.onGuiOpened(player);
    }

    protected void onGuiOpened(EntityPlayer player) {
    }

    protected boolean useMui2() {
        return false;
    }

    protected boolean forceUseMui2() {
        return false;
    }

    @Override
    public final String getGuiId() {
        return this.mName;
    }

    protected GTGuiTheme getGuiTheme() {
        return GTGuiThemes.STANDARD;
    }

    public ModularPanel buildUI(PosGuiData data, PanelSyncManager syncManager, UISettings uiSettings) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModularScreen createScreen(PosGuiData data, ModularPanel mainPanel) {
        return new GTModularScreen(mainPanel, this.getGuiTheme());
    }
}

